/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse;

public class ListBonusPaymentsIterable
implements SdkIterable<ListBonusPaymentsResponse> {
    private final MTurkClient client;
    private final ListBonusPaymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBonusPaymentsIterable(MTurkClient client, ListBonusPaymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBonusPaymentsResponseFetcher();
    }

    public Iterator<ListBonusPaymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListBonusPaymentsIterable resume(ListBonusPaymentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListBonusPaymentsIterable(this.client, (ListBonusPaymentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListBonusPaymentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListBonusPaymentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListBonusPaymentsResponseFetcher
    implements SyncPageFetcher<ListBonusPaymentsResponse> {
        private ListBonusPaymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListBonusPaymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBonusPaymentsResponse nextPage(ListBonusPaymentsResponse previousPage) {
            if (previousPage == null) {
                return ListBonusPaymentsIterable.this.client.listBonusPayments(ListBonusPaymentsIterable.this.firstRequest);
            }
            return ListBonusPaymentsIterable.this.client.listBonusPayments((ListBonusPaymentsRequest)((Object)ListBonusPaymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

