/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.WorkerBlock;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WorkerBlockMarshaller {
    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reason").isBinary(false).build();
    private static final WorkerBlockMarshaller INSTANCE = new WorkerBlockMarshaller();

    private WorkerBlockMarshaller() {
    }

    public static WorkerBlockMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WorkerBlock workerBlock, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)workerBlock, (String)"workerBlock");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)workerBlock.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall((Object)workerBlock.reason(), REASON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

