/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.ReviewReport;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReviewReportMarshaller {
    private static final MarshallingInfo<List> REVIEWRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReviewResults").isBinary(false).build();
    private static final MarshallingInfo<List> REVIEWACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReviewActions").isBinary(false).build();
    private static final ReviewReportMarshaller INSTANCE = new ReviewReportMarshaller();

    private ReviewReportMarshaller() {
    }

    public static ReviewReportMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReviewReport reviewReport, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reviewReport, (String)"reviewReport");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(reviewReport.reviewResults(), REVIEWRESULTS_BINDING);
            protocolMarshaller.marshall(reviewReport.reviewActions(), REVIEWACTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

