/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mturk.model.Qualification;
import software.amazon.awssdk.services.mturk.transform.LocaleUnmarshaller;

public class QualificationUnmarshaller
implements Unmarshaller<Qualification, JsonUnmarshallerContext> {
    private static final QualificationUnmarshaller INSTANCE = new QualificationUnmarshaller();

    public Qualification unmarshall(JsonUnmarshallerContext context) throws Exception {
        Qualification.Builder qualificationBuilder = Qualification.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("QualificationTypeId", targetDepth)) {
                    context.nextToken();
                    qualificationBuilder.qualificationTypeId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("WorkerId", targetDepth)) {
                    context.nextToken();
                    qualificationBuilder.workerId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("GrantTime", targetDepth)) {
                    context.nextToken();
                    qualificationBuilder.grantTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("IntegerValue", targetDepth)) {
                    context.nextToken();
                    qualificationBuilder.integerValue((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("LocaleValue", targetDepth)) {
                    context.nextToken();
                    qualificationBuilder.localeValue(LocaleUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    qualificationBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Qualification)qualificationBuilder.build();
    }

    public static QualificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

