/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.QualificationType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QualificationTypeMarshaller {
    private static final MarshallingInfo<String> QUALIFICATIONTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationTypeId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> KEYWORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keywords").isBinary(false).build();
    private static final MarshallingInfo<String> QUALIFICATIONTYPESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationTypeStatus").isBinary(false).build();
    private static final MarshallingInfo<String> TEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Test").isBinary(false).build();
    private static final MarshallingInfo<Long> TESTDURATIONINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TestDurationInSeconds").isBinary(false).build();
    private static final MarshallingInfo<String> ANSWERKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnswerKey").isBinary(false).build();
    private static final MarshallingInfo<Long> RETRYDELAYINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryDelayInSeconds").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISREQUESTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsRequestable").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AUTOGRANTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoGranted").isBinary(false).build();
    private static final MarshallingInfo<Integer> AUTOGRANTEDVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoGrantedValue").isBinary(false).build();
    private static final QualificationTypeMarshaller INSTANCE = new QualificationTypeMarshaller();

    private QualificationTypeMarshaller() {
    }

    public static QualificationTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QualificationType qualificationType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)qualificationType, (String)"qualificationType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)qualificationType.qualificationTypeId(), QUALIFICATIONTYPEID_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.keywords(), KEYWORDS_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.qualificationTypeStatusAsString(), QUALIFICATIONTYPESTATUS_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.test(), TEST_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.testDurationInSeconds(), TESTDURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.answerKey(), ANSWERKEY_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.retryDelayInSeconds(), RETRYDELAYINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.isRequestable(), ISREQUESTABLE_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.autoGranted(), AUTOGRANTED_BINDING);
            protocolMarshaller.marshall((Object)qualificationType.autoGrantedValue(), AUTOGRANTEDVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

