/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.PolicyParameter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyParameterMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final MarshallingInfo<List> MAPENTRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MapEntries").isBinary(false).build();
    private static final PolicyParameterMarshaller INSTANCE = new PolicyParameterMarshaller();

    private PolicyParameterMarshaller() {
    }

    public static PolicyParameterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyParameter policyParameter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policyParameter, (String)"policyParameter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policyParameter.key(), KEY_BINDING);
            protocolMarshaller.marshall(policyParameter.values(), VALUES_BINDING);
            protocolMarshaller.marshall(policyParameter.mapEntries(), MAPENTRIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

