/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.ParameterMapEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParameterMapEntryMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final ParameterMapEntryMarshaller INSTANCE = new ParameterMapEntryMarshaller();

    private ParameterMapEntryMarshaller() {
    }

    public static ParameterMapEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ParameterMapEntry parameterMapEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parameterMapEntry, (String)"parameterMapEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parameterMapEntry.key(), KEY_BINDING);
            protocolMarshaller.marshall(parameterMapEntry.values(), VALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

