/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotifyWorkersRequestModelMarshaller {
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subject").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGETEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageText").isBinary(false).build();
    private static final MarshallingInfo<List> WORKERIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerIds").isBinary(false).build();
    private static final NotifyWorkersRequestModelMarshaller INSTANCE = new NotifyWorkersRequestModelMarshaller();

    private NotifyWorkersRequestModelMarshaller() {
    }

    public static NotifyWorkersRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotifyWorkersRequest notifyWorkersRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)notifyWorkersRequest), (String)"notifyWorkersRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notifyWorkersRequest.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)notifyWorkersRequest.messageText(), MESSAGETEXT_BINDING);
            protocolMarshaller.marshall(notifyWorkersRequest.workerIds(), WORKERIDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

