/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.Locale;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LocaleMarshaller {
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").isBinary(false).build();
    private static final MarshallingInfo<String> SUBDIVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subdivision").isBinary(false).build();
    private static final LocaleMarshaller INSTANCE = new LocaleMarshaller();

    private LocaleMarshaller() {
    }

    public static LocaleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Locale locale, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)locale, (String)"locale");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)locale.country(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)locale.subdivision(), SUBDIVISION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

