/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.HIT;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HITMarshaller {
    private static final MarshallingInfo<String> HITID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITId").isBinary(false).build();
    private static final MarshallingInfo<String> HITTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITTypeId").isBinary(false).build();
    private static final MarshallingInfo<String> HITGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITGroupId").isBinary(false).build();
    private static final MarshallingInfo<String> HITLAYOUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITLayoutId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> QUESTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Question").isBinary(false).build();
    private static final MarshallingInfo<String> KEYWORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keywords").isBinary(false).build();
    private static final MarshallingInfo<String> HITSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITStatus").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXASSIGNMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxAssignments").isBinary(false).build();
    private static final MarshallingInfo<String> REWARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reward").isBinary(false).build();
    private static final MarshallingInfo<Long> AUTOAPPROVALDELAYINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoApprovalDelayInSeconds").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expiration").isBinary(false).build();
    private static final MarshallingInfo<Long> ASSIGNMENTDURATIONINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentDurationInSeconds").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTERANNOTATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequesterAnnotation").isBinary(false).build();
    private static final MarshallingInfo<List> QUALIFICATIONREQUIREMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationRequirements").isBinary(false).build();
    private static final MarshallingInfo<String> HITREVIEWSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITReviewStatus").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFASSIGNMENTSPENDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfAssignmentsPending").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFASSIGNMENTSAVAILABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfAssignmentsAvailable").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFASSIGNMENTSCOMPLETED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfAssignmentsCompleted").isBinary(false).build();
    private static final HITMarshaller INSTANCE = new HITMarshaller();

    private HITMarshaller() {
    }

    public static HITMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HIT hit, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hit, (String)"hit");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hit.hitId(), HITID_BINDING);
            protocolMarshaller.marshall((Object)hit.hitTypeId(), HITTYPEID_BINDING);
            protocolMarshaller.marshall((Object)hit.hitGroupId(), HITGROUPID_BINDING);
            protocolMarshaller.marshall((Object)hit.hitLayoutId(), HITLAYOUTID_BINDING);
            protocolMarshaller.marshall((Object)hit.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)hit.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)hit.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)hit.question(), QUESTION_BINDING);
            protocolMarshaller.marshall((Object)hit.keywords(), KEYWORDS_BINDING);
            protocolMarshaller.marshall((Object)hit.hitStatusAsString(), HITSTATUS_BINDING);
            protocolMarshaller.marshall((Object)hit.maxAssignments(), MAXASSIGNMENTS_BINDING);
            protocolMarshaller.marshall((Object)hit.reward(), REWARD_BINDING);
            protocolMarshaller.marshall((Object)hit.autoApprovalDelayInSeconds(), AUTOAPPROVALDELAYINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)hit.expiration(), EXPIRATION_BINDING);
            protocolMarshaller.marshall((Object)hit.assignmentDurationInSeconds(), ASSIGNMENTDURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)hit.requesterAnnotation(), REQUESTERANNOTATION_BINDING);
            protocolMarshaller.marshall(hit.qualificationRequirements(), QUALIFICATIONREQUIREMENTS_BINDING);
            protocolMarshaller.marshall((Object)hit.hitReviewStatusAsString(), HITREVIEWSTATUS_BINDING);
            protocolMarshaller.marshall((Object)hit.numberOfAssignmentsPending(), NUMBEROFASSIGNMENTSPENDING_BINDING);
            protocolMarshaller.marshall((Object)hit.numberOfAssignmentsAvailable(), NUMBEROFASSIGNMENTSAVAILABLE_BINDING);
            protocolMarshaller.marshall((Object)hit.numberOfAssignmentsCompleted(), NUMBEROFASSIGNMENTSCOMPLETED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

