/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.Assignment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AssignmentMarshaller {
    private static final MarshallingInfo<String> ASSIGNMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentId").isBinary(false).build();
    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();
    private static final MarshallingInfo<String> HITID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITId").isBinary(false).build();
    private static final MarshallingInfo<String> ASSIGNMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> AUTOAPPROVALTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoApprovalTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ACCEPTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> APPROVALTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovalTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> REJECTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RejectionTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> DEADLINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deadline").isBinary(false).build();
    private static final MarshallingInfo<String> ANSWER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Answer").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTERFEEDBACK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequesterFeedback").isBinary(false).build();
    private static final AssignmentMarshaller INSTANCE = new AssignmentMarshaller();

    private AssignmentMarshaller() {
    }

    public static AssignmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Assignment assignment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)assignment, (String)"assignment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)assignment.assignmentId(), ASSIGNMENTID_BINDING);
            protocolMarshaller.marshall((Object)assignment.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall((Object)assignment.hitId(), HITID_BINDING);
            protocolMarshaller.marshall((Object)assignment.assignmentStatusAsString(), ASSIGNMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)assignment.autoApprovalTime(), AUTOAPPROVALTIME_BINDING);
            protocolMarshaller.marshall((Object)assignment.acceptTime(), ACCEPTTIME_BINDING);
            protocolMarshaller.marshall((Object)assignment.submitTime(), SUBMITTIME_BINDING);
            protocolMarshaller.marshall((Object)assignment.approvalTime(), APPROVALTIME_BINDING);
            protocolMarshaller.marshall((Object)assignment.rejectionTime(), REJECTIONTIME_BINDING);
            protocolMarshaller.marshall((Object)assignment.deadline(), DEADLINE_BINDING);
            protocolMarshaller.marshall((Object)assignment.answer(), ANSWER_BINDING);
            protocolMarshaller.marshall((Object)assignment.requesterFeedback(), REQUESTERFEEDBACK_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

