/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHitReviewStatusRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, UpdateHitReviewStatusRequest> {
    private final String hitId;
    private final Boolean revert;

    private UpdateHitReviewStatusRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.revert = builder.revert;
    }

    public String hitId() {
        return this.hitId;
    }

    public Boolean revert() {
        return this.revert;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revert());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHitReviewStatusRequest)) {
            return false;
        }
        UpdateHitReviewStatusRequest other = (UpdateHitReviewStatusRequest)((Object)obj);
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.revert(), other.revert());
    }

    public String toString() {
        return ToString.builder((String)"UpdateHitReviewStatusRequest").add("HITId", (Object)this.hitId()).add("Revert", (Object)this.revert()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "Revert": {
                return Optional.ofNullable(clazz.cast(this.revert()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitId;
        private Boolean revert;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHitReviewStatusRequest model) {
            super(model);
            this.hitId(model.hitId);
            this.revert(model.revert);
        }

        public final String getHITId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final Boolean getRevert() {
            return this.revert;
        }

        @Override
        public final Builder revert(Boolean revert) {
            this.revert = revert;
            return this;
        }

        public final void setRevert(Boolean revert) {
            this.revert = revert;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHitReviewStatusRequest build() {
            return new UpdateHitReviewStatusRequest(this);
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    CopyableBuilder<Builder, UpdateHitReviewStatusRequest> {
        public Builder hitId(String var1);

        public Builder revert(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

