/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.ReviewActionDetail;
import software.amazon.awssdk.services.mturk.model.ReviewActionDetailListCopier;
import software.amazon.awssdk.services.mturk.model.ReviewResultDetail;
import software.amazon.awssdk.services.mturk.model.ReviewResultDetailListCopier;
import software.amazon.awssdk.services.mturk.transform.ReviewReportMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewReport
implements StructuredPojo,
ToCopyableBuilder<Builder, ReviewReport> {
    private final List<ReviewResultDetail> reviewResults;
    private final List<ReviewActionDetail> reviewActions;

    private ReviewReport(BuilderImpl builder) {
        this.reviewResults = builder.reviewResults;
        this.reviewActions = builder.reviewActions;
    }

    public List<ReviewResultDetail> reviewResults() {
        return this.reviewResults;
    }

    public List<ReviewActionDetail> reviewActions() {
        return this.reviewActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewReport)) {
            return false;
        }
        ReviewReport other = (ReviewReport)obj;
        return Objects.equals(this.reviewResults(), other.reviewResults()) && Objects.equals(this.reviewActions(), other.reviewActions());
    }

    public String toString() {
        return ToString.builder((String)"ReviewReport").add("ReviewResults", this.reviewResults()).add("ReviewActions", this.reviewActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReviewResults": {
                return Optional.ofNullable(clazz.cast(this.reviewResults()));
            }
            case "ReviewActions": {
                return Optional.ofNullable(clazz.cast(this.reviewActions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReviewReportMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReviewResultDetail> reviewResults = DefaultSdkAutoConstructList.getInstance();
        private List<ReviewActionDetail> reviewActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewReport model) {
            this.reviewResults(model.reviewResults);
            this.reviewActions(model.reviewActions);
        }

        public final Collection<ReviewResultDetail.Builder> getReviewResults() {
            return this.reviewResults != null ? (Collection)this.reviewResults.stream().map(ReviewResultDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reviewResults(Collection<ReviewResultDetail> reviewResults) {
            this.reviewResults = ReviewResultDetailListCopier.copy(reviewResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewResults(ReviewResultDetail ... reviewResults) {
            this.reviewResults(Arrays.asList(reviewResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewResults(Consumer<ReviewResultDetail.Builder> ... reviewResults) {
            this.reviewResults(Stream.of(reviewResults).map(c -> (ReviewResultDetail)((ReviewResultDetail.Builder)ReviewResultDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReviewResults(Collection<ReviewResultDetail.BuilderImpl> reviewResults) {
            this.reviewResults = ReviewResultDetailListCopier.copyFromBuilder(reviewResults);
        }

        public final Collection<ReviewActionDetail.Builder> getReviewActions() {
            return this.reviewActions != null ? (Collection)this.reviewActions.stream().map(ReviewActionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reviewActions(Collection<ReviewActionDetail> reviewActions) {
            this.reviewActions = ReviewActionDetailListCopier.copy(reviewActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewActions(ReviewActionDetail ... reviewActions) {
            this.reviewActions(Arrays.asList(reviewActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewActions(Consumer<ReviewActionDetail.Builder> ... reviewActions) {
            this.reviewActions(Stream.of(reviewActions).map(c -> (ReviewActionDetail)((ReviewActionDetail.Builder)ReviewActionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReviewActions(Collection<ReviewActionDetail.BuilderImpl> reviewActions) {
            this.reviewActions = ReviewActionDetailListCopier.copyFromBuilder(reviewActions);
        }

        public ReviewReport build() {
            return new ReviewReport(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReviewReport> {
        public Builder reviewResults(Collection<ReviewResultDetail> var1);

        public Builder reviewResults(ReviewResultDetail ... var1);

        public Builder reviewResults(Consumer<ReviewResultDetail.Builder> ... var1);

        public Builder reviewActions(Collection<ReviewActionDetail> var1);

        public Builder reviewActions(ReviewActionDetail ... var1);

        public Builder reviewActions(Consumer<ReviewActionDetail.Builder> ... var1);
    }
}

