/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.model.Locale;
import software.amazon.awssdk.services.mturk.model.QualificationStatus;
import software.amazon.awssdk.services.mturk.transform.QualificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Qualification
implements StructuredPojo,
ToCopyableBuilder<Builder, Qualification> {
    private final String qualificationTypeId;
    private final String workerId;
    private final Instant grantTime;
    private final Integer integerValue;
    private final Locale localeValue;
    private final String status;

    private Qualification(BuilderImpl builder) {
        this.qualificationTypeId = builder.qualificationTypeId;
        this.workerId = builder.workerId;
        this.grantTime = builder.grantTime;
        this.integerValue = builder.integerValue;
        this.localeValue = builder.localeValue;
        this.status = builder.status;
    }

    public String qualificationTypeId() {
        return this.qualificationTypeId;
    }

    public String workerId() {
        return this.workerId;
    }

    public Instant grantTime() {
        return this.grantTime;
    }

    public Integer integerValue() {
        return this.integerValue;
    }

    public Locale localeValue() {
        return this.localeValue;
    }

    public QualificationStatus status() {
        return QualificationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Qualification)) {
            return false;
        }
        Qualification other = (Qualification)obj;
        return Objects.equals(this.qualificationTypeId(), other.qualificationTypeId()) && Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.grantTime(), other.grantTime()) && Objects.equals(this.integerValue(), other.integerValue()) && Objects.equals(this.localeValue(), other.localeValue()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"Qualification").add("QualificationTypeId", (Object)this.qualificationTypeId()).add("WorkerId", (Object)this.workerId()).add("GrantTime", (Object)this.grantTime()).add("IntegerValue", (Object)this.integerValue()).add("LocaleValue", (Object)this.localeValue()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QualificationTypeId": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypeId()));
            }
            case "WorkerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "GrantTime": {
                return Optional.ofNullable(clazz.cast(this.grantTime()));
            }
            case "IntegerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "LocaleValue": {
                return Optional.ofNullable(clazz.cast(this.localeValue()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QualificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String qualificationTypeId;
        private String workerId;
        private Instant grantTime;
        private Integer integerValue;
        private Locale localeValue;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Qualification model) {
            this.qualificationTypeId(model.qualificationTypeId);
            this.workerId(model.workerId);
            this.grantTime(model.grantTime);
            this.integerValue(model.integerValue);
            this.localeValue(model.localeValue);
            this.status(model.status);
        }

        public final String getQualificationTypeId() {
            return this.qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final Instant getGrantTime() {
            return this.grantTime;
        }

        @Override
        public final Builder grantTime(Instant grantTime) {
            this.grantTime = grantTime;
            return this;
        }

        public final void setGrantTime(Instant grantTime) {
            this.grantTime = grantTime;
        }

        public final Integer getIntegerValue() {
            return this.integerValue;
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        public final Locale.Builder getLocaleValue() {
            return this.localeValue != null ? this.localeValue.toBuilder() : null;
        }

        @Override
        public final Builder localeValue(Locale localeValue) {
            this.localeValue = localeValue;
            return this;
        }

        public final void setLocaleValue(Locale.BuilderImpl localeValue) {
            this.localeValue = localeValue != null ? localeValue.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QualificationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public Qualification build() {
            return new Qualification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Qualification> {
        public Builder qualificationTypeId(String var1);

        public Builder workerId(String var1);

        public Builder grantTime(Instant var1);

        public Builder integerValue(Integer var1);

        public Builder localeValue(Locale var1);

        default public Builder localeValue(Consumer<Locale.Builder> localeValue) {
            return this.localeValue((Locale)((Locale.Builder)Locale.builder().applyMutation(localeValue)).build());
        }

        public Builder status(String var1);

        public Builder status(QualificationStatus var1);
    }
}

