/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.LocaleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Locale
implements StructuredPojo,
ToCopyableBuilder<Builder, Locale> {
    private final String country;
    private final String subdivision;

    private Locale(BuilderImpl builder) {
        this.country = builder.country;
        this.subdivision = builder.subdivision;
    }

    public String country() {
        return this.country;
    }

    public String subdivision() {
        return this.subdivision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdivision());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale other = (Locale)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.subdivision(), other.subdivision());
    }

    public String toString() {
        return ToString.builder((String)"Locale").add("Country", (Object)this.country()).add("Subdivision", (Object)this.subdivision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Subdivision": {
                return Optional.ofNullable(clazz.cast(this.subdivision()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocaleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String country;
        private String subdivision;

        private BuilderImpl() {
        }

        private BuilderImpl(Locale model) {
            this.country(model.country);
            this.subdivision(model.subdivision);
        }

        public final String getCountry() {
            return this.country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getSubdivision() {
            return this.subdivision;
        }

        @Override
        public final Builder subdivision(String subdivision) {
            this.subdivision = subdivision;
            return this;
        }

        public final void setSubdivision(String subdivision) {
            this.subdivision = subdivision;
        }

        public Locale build() {
            return new Locale(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Locale> {
        public Builder country(String var1);

        public Builder subdivision(String var1);
    }
}

