/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.services.mturk.model.Qualification;
import software.amazon.awssdk.services.mturk.model.QualificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkersWithQualificationTypeResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListWorkersWithQualificationTypeResponse> {
    private final String nextToken;
    private final Integer numResults;
    private final List<Qualification> qualifications;

    private ListWorkersWithQualificationTypeResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.qualifications = builder.qualifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer numResults() {
        return this.numResults;
    }

    public List<Qualification> qualifications() {
        return this.qualifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkersWithQualificationTypeResponse)) {
            return false;
        }
        ListWorkersWithQualificationTypeResponse other = (ListWorkersWithQualificationTypeResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.qualifications(), other.qualifications());
    }

    public String toString() {
        return ToString.builder((String)"ListWorkersWithQualificationTypeResponse").add("NextToken", (Object)this.nextToken()).add("NumResults", (Object)this.numResults()).add("Qualifications", this.qualifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "Qualifications": {
                return Optional.ofNullable(clazz.cast(this.qualifications()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer numResults;
        private List<Qualification> qualifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkersWithQualificationTypeResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.numResults(model.numResults);
            this.qualifications(model.qualifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final Collection<Qualification.Builder> getQualifications() {
            return this.qualifications != null ? (Collection)this.qualifications.stream().map(Qualification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder qualifications(Collection<Qualification> qualifications) {
            this.qualifications = QualificationListCopier.copy(qualifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifications(Qualification ... qualifications) {
            this.qualifications(Arrays.asList(qualifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifications(Consumer<Qualification.Builder> ... qualifications) {
            this.qualifications(Stream.of(qualifications).map(c -> (Qualification)((Qualification.Builder)Qualification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQualifications(Collection<Qualification.BuilderImpl> qualifications) {
            this.qualifications = QualificationListCopier.copyFromBuilder(qualifications);
        }

        @Override
        public ListWorkersWithQualificationTypeResponse build() {
            return new ListWorkersWithQualificationTypeResponse(this);
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    CopyableBuilder<Builder, ListWorkersWithQualificationTypeResponse> {
        public Builder nextToken(String var1);

        public Builder numResults(Integer var1);

        public Builder qualifications(Collection<Qualification> var1);

        public Builder qualifications(Qualification ... var1);

        public Builder qualifications(Consumer<Qualification.Builder> ... var1);
    }
}

