/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.HITReviewStatus;
import software.amazon.awssdk.services.mturk.model.HITStatus;
import software.amazon.awssdk.services.mturk.model.QualificationRequirement;
import software.amazon.awssdk.services.mturk.model.QualificationRequirementListCopier;
import software.amazon.awssdk.services.mturk.transform.HITMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HIT
implements StructuredPojo,
ToCopyableBuilder<Builder, HIT> {
    private final String hitId;
    private final String hitTypeId;
    private final String hitGroupId;
    private final String hitLayoutId;
    private final Instant creationTime;
    private final String title;
    private final String description;
    private final String question;
    private final String keywords;
    private final String hitStatus;
    private final Integer maxAssignments;
    private final String reward;
    private final Long autoApprovalDelayInSeconds;
    private final Instant expiration;
    private final Long assignmentDurationInSeconds;
    private final String requesterAnnotation;
    private final List<QualificationRequirement> qualificationRequirements;
    private final String hitReviewStatus;
    private final Integer numberOfAssignmentsPending;
    private final Integer numberOfAssignmentsAvailable;
    private final Integer numberOfAssignmentsCompleted;

    private HIT(BuilderImpl builder) {
        this.hitId = builder.hitId;
        this.hitTypeId = builder.hitTypeId;
        this.hitGroupId = builder.hitGroupId;
        this.hitLayoutId = builder.hitLayoutId;
        this.creationTime = builder.creationTime;
        this.title = builder.title;
        this.description = builder.description;
        this.question = builder.question;
        this.keywords = builder.keywords;
        this.hitStatus = builder.hitStatus;
        this.maxAssignments = builder.maxAssignments;
        this.reward = builder.reward;
        this.autoApprovalDelayInSeconds = builder.autoApprovalDelayInSeconds;
        this.expiration = builder.expiration;
        this.assignmentDurationInSeconds = builder.assignmentDurationInSeconds;
        this.requesterAnnotation = builder.requesterAnnotation;
        this.qualificationRequirements = builder.qualificationRequirements;
        this.hitReviewStatus = builder.hitReviewStatus;
        this.numberOfAssignmentsPending = builder.numberOfAssignmentsPending;
        this.numberOfAssignmentsAvailable = builder.numberOfAssignmentsAvailable;
        this.numberOfAssignmentsCompleted = builder.numberOfAssignmentsCompleted;
    }

    public String hitId() {
        return this.hitId;
    }

    public String hitTypeId() {
        return this.hitTypeId;
    }

    public String hitGroupId() {
        return this.hitGroupId;
    }

    public String hitLayoutId() {
        return this.hitLayoutId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    public String question() {
        return this.question;
    }

    public String keywords() {
        return this.keywords;
    }

    public HITStatus hitStatus() {
        return HITStatus.fromValue(this.hitStatus);
    }

    public String hitStatusAsString() {
        return this.hitStatus;
    }

    public Integer maxAssignments() {
        return this.maxAssignments;
    }

    public String reward() {
        return this.reward;
    }

    public Long autoApprovalDelayInSeconds() {
        return this.autoApprovalDelayInSeconds;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Long assignmentDurationInSeconds() {
        return this.assignmentDurationInSeconds;
    }

    public String requesterAnnotation() {
        return this.requesterAnnotation;
    }

    public List<QualificationRequirement> qualificationRequirements() {
        return this.qualificationRequirements;
    }

    public HITReviewStatus hitReviewStatus() {
        return HITReviewStatus.fromValue(this.hitReviewStatus);
    }

    public String hitReviewStatusAsString() {
        return this.hitReviewStatus;
    }

    public Integer numberOfAssignmentsPending() {
        return this.numberOfAssignmentsPending;
    }

    public Integer numberOfAssignmentsAvailable() {
        return this.numberOfAssignmentsAvailable;
    }

    public Integer numberOfAssignmentsCompleted() {
        return this.numberOfAssignmentsCompleted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitLayoutId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.question());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(this.reward());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoApprovalDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAnnotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitReviewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssignmentsPending());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssignmentsAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssignmentsCompleted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HIT)) {
            return false;
        }
        HIT other = (HIT)obj;
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.hitTypeId(), other.hitTypeId()) && Objects.equals(this.hitGroupId(), other.hitGroupId()) && Objects.equals(this.hitLayoutId(), other.hitLayoutId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.question(), other.question()) && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.hitStatusAsString(), other.hitStatusAsString()) && Objects.equals(this.maxAssignments(), other.maxAssignments()) && Objects.equals(this.reward(), other.reward()) && Objects.equals(this.autoApprovalDelayInSeconds(), other.autoApprovalDelayInSeconds()) && Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.assignmentDurationInSeconds(), other.assignmentDurationInSeconds()) && Objects.equals(this.requesterAnnotation(), other.requesterAnnotation()) && Objects.equals(this.qualificationRequirements(), other.qualificationRequirements()) && Objects.equals(this.hitReviewStatusAsString(), other.hitReviewStatusAsString()) && Objects.equals(this.numberOfAssignmentsPending(), other.numberOfAssignmentsPending()) && Objects.equals(this.numberOfAssignmentsAvailable(), other.numberOfAssignmentsAvailable()) && Objects.equals(this.numberOfAssignmentsCompleted(), other.numberOfAssignmentsCompleted());
    }

    public String toString() {
        return ToString.builder((String)"HIT").add("HITId", (Object)this.hitId()).add("HITTypeId", (Object)this.hitTypeId()).add("HITGroupId", (Object)this.hitGroupId()).add("HITLayoutId", (Object)this.hitLayoutId()).add("CreationTime", (Object)this.creationTime()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Question", (Object)this.question()).add("Keywords", (Object)this.keywords()).add("HITStatus", (Object)this.hitStatusAsString()).add("MaxAssignments", (Object)this.maxAssignments()).add("Reward", (Object)this.reward()).add("AutoApprovalDelayInSeconds", (Object)this.autoApprovalDelayInSeconds()).add("Expiration", (Object)this.expiration()).add("AssignmentDurationInSeconds", (Object)this.assignmentDurationInSeconds()).add("RequesterAnnotation", (Object)this.requesterAnnotation()).add("QualificationRequirements", this.qualificationRequirements()).add("HITReviewStatus", (Object)this.hitReviewStatusAsString()).add("NumberOfAssignmentsPending", (Object)this.numberOfAssignmentsPending()).add("NumberOfAssignmentsAvailable", (Object)this.numberOfAssignmentsAvailable()).add("NumberOfAssignmentsCompleted", (Object)this.numberOfAssignmentsCompleted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "HITTypeId": {
                return Optional.ofNullable(clazz.cast(this.hitTypeId()));
            }
            case "HITGroupId": {
                return Optional.ofNullable(clazz.cast(this.hitGroupId()));
            }
            case "HITLayoutId": {
                return Optional.ofNullable(clazz.cast(this.hitLayoutId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Question": {
                return Optional.ofNullable(clazz.cast(this.question()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "HITStatus": {
                return Optional.ofNullable(clazz.cast(this.hitStatusAsString()));
            }
            case "MaxAssignments": {
                return Optional.ofNullable(clazz.cast(this.maxAssignments()));
            }
            case "Reward": {
                return Optional.ofNullable(clazz.cast(this.reward()));
            }
            case "AutoApprovalDelayInSeconds": {
                return Optional.ofNullable(clazz.cast(this.autoApprovalDelayInSeconds()));
            }
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
            case "AssignmentDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.assignmentDurationInSeconds()));
            }
            case "RequesterAnnotation": {
                return Optional.ofNullable(clazz.cast(this.requesterAnnotation()));
            }
            case "QualificationRequirements": {
                return Optional.ofNullable(clazz.cast(this.qualificationRequirements()));
            }
            case "HITReviewStatus": {
                return Optional.ofNullable(clazz.cast(this.hitReviewStatusAsString()));
            }
            case "NumberOfAssignmentsPending": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssignmentsPending()));
            }
            case "NumberOfAssignmentsAvailable": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssignmentsAvailable()));
            }
            case "NumberOfAssignmentsCompleted": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssignmentsCompleted()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HITMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String hitId;
        private String hitTypeId;
        private String hitGroupId;
        private String hitLayoutId;
        private Instant creationTime;
        private String title;
        private String description;
        private String question;
        private String keywords;
        private String hitStatus;
        private Integer maxAssignments;
        private String reward;
        private Long autoApprovalDelayInSeconds;
        private Instant expiration;
        private Long assignmentDurationInSeconds;
        private String requesterAnnotation;
        private List<QualificationRequirement> qualificationRequirements = DefaultSdkAutoConstructList.getInstance();
        private String hitReviewStatus;
        private Integer numberOfAssignmentsPending;
        private Integer numberOfAssignmentsAvailable;
        private Integer numberOfAssignmentsCompleted;

        private BuilderImpl() {
        }

        private BuilderImpl(HIT model) {
            this.hitId(model.hitId);
            this.hitTypeId(model.hitTypeId);
            this.hitGroupId(model.hitGroupId);
            this.hitLayoutId(model.hitLayoutId);
            this.creationTime(model.creationTime);
            this.title(model.title);
            this.description(model.description);
            this.question(model.question);
            this.keywords(model.keywords);
            this.hitStatus(model.hitStatus);
            this.maxAssignments(model.maxAssignments);
            this.reward(model.reward);
            this.autoApprovalDelayInSeconds(model.autoApprovalDelayInSeconds);
            this.expiration(model.expiration);
            this.assignmentDurationInSeconds(model.assignmentDurationInSeconds);
            this.requesterAnnotation(model.requesterAnnotation);
            this.qualificationRequirements(model.qualificationRequirements);
            this.hitReviewStatus(model.hitReviewStatus);
            this.numberOfAssignmentsPending(model.numberOfAssignmentsPending);
            this.numberOfAssignmentsAvailable(model.numberOfAssignmentsAvailable);
            this.numberOfAssignmentsCompleted(model.numberOfAssignmentsCompleted);
        }

        public final String getHITId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final String getHITTypeId() {
            return this.hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final void setHITTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        public final String getHITGroupId() {
            return this.hitGroupId;
        }

        @Override
        public final Builder hitGroupId(String hitGroupId) {
            this.hitGroupId = hitGroupId;
            return this;
        }

        public final void setHITGroupId(String hitGroupId) {
            this.hitGroupId = hitGroupId;
        }

        public final String getHITLayoutId() {
            return this.hitLayoutId;
        }

        @Override
        public final Builder hitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
            return this;
        }

        public final void setHITLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getQuestion() {
            return this.question;
        }

        @Override
        public final Builder question(String question) {
            this.question = question;
            return this;
        }

        public final void setQuestion(String question) {
            this.question = question;
        }

        public final String getKeywords() {
            return this.keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public final String getHITStatus() {
            return this.hitStatus;
        }

        @Override
        public final Builder hitStatus(String hitStatus) {
            this.hitStatus = hitStatus;
            return this;
        }

        @Override
        public final Builder hitStatus(HITStatus hitStatus) {
            this.hitStatus(hitStatus.toString());
            return this;
        }

        public final void setHITStatus(String hitStatus) {
            this.hitStatus = hitStatus;
        }

        public final Integer getMaxAssignments() {
            return this.maxAssignments;
        }

        @Override
        public final Builder maxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
            return this;
        }

        public final void setMaxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
        }

        public final String getReward() {
            return this.reward;
        }

        @Override
        public final Builder reward(String reward) {
            this.reward = reward;
            return this;
        }

        public final void setReward(String reward) {
            this.reward = reward;
        }

        public final Long getAutoApprovalDelayInSeconds() {
            return this.autoApprovalDelayInSeconds;
        }

        @Override
        public final Builder autoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
            return this;
        }

        public final void setAutoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        public final Long getAssignmentDurationInSeconds() {
            return this.assignmentDurationInSeconds;
        }

        @Override
        public final Builder assignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
            return this;
        }

        public final void setAssignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
        }

        public final String getRequesterAnnotation() {
            return this.requesterAnnotation;
        }

        @Override
        public final Builder requesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
            return this;
        }

        public final void setRequesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
        }

        public final Collection<QualificationRequirement.Builder> getQualificationRequirements() {
            return this.qualificationRequirements != null ? (Collection)this.qualificationRequirements.stream().map(QualificationRequirement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder qualificationRequirements(Collection<QualificationRequirement> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copy(qualificationRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(QualificationRequirement ... qualificationRequirements) {
            this.qualificationRequirements(Arrays.asList(qualificationRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(Consumer<QualificationRequirement.Builder> ... qualificationRequirements) {
            this.qualificationRequirements(Stream.of(qualificationRequirements).map(c -> (QualificationRequirement)((QualificationRequirement.Builder)QualificationRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQualificationRequirements(Collection<QualificationRequirement.BuilderImpl> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copyFromBuilder(qualificationRequirements);
        }

        public final String getHITReviewStatus() {
            return this.hitReviewStatus;
        }

        @Override
        public final Builder hitReviewStatus(String hitReviewStatus) {
            this.hitReviewStatus = hitReviewStatus;
            return this;
        }

        @Override
        public final Builder hitReviewStatus(HITReviewStatus hitReviewStatus) {
            this.hitReviewStatus(hitReviewStatus.toString());
            return this;
        }

        public final void setHITReviewStatus(String hitReviewStatus) {
            this.hitReviewStatus = hitReviewStatus;
        }

        public final Integer getNumberOfAssignmentsPending() {
            return this.numberOfAssignmentsPending;
        }

        @Override
        public final Builder numberOfAssignmentsPending(Integer numberOfAssignmentsPending) {
            this.numberOfAssignmentsPending = numberOfAssignmentsPending;
            return this;
        }

        public final void setNumberOfAssignmentsPending(Integer numberOfAssignmentsPending) {
            this.numberOfAssignmentsPending = numberOfAssignmentsPending;
        }

        public final Integer getNumberOfAssignmentsAvailable() {
            return this.numberOfAssignmentsAvailable;
        }

        @Override
        public final Builder numberOfAssignmentsAvailable(Integer numberOfAssignmentsAvailable) {
            this.numberOfAssignmentsAvailable = numberOfAssignmentsAvailable;
            return this;
        }

        public final void setNumberOfAssignmentsAvailable(Integer numberOfAssignmentsAvailable) {
            this.numberOfAssignmentsAvailable = numberOfAssignmentsAvailable;
        }

        public final Integer getNumberOfAssignmentsCompleted() {
            return this.numberOfAssignmentsCompleted;
        }

        @Override
        public final Builder numberOfAssignmentsCompleted(Integer numberOfAssignmentsCompleted) {
            this.numberOfAssignmentsCompleted = numberOfAssignmentsCompleted;
            return this;
        }

        public final void setNumberOfAssignmentsCompleted(Integer numberOfAssignmentsCompleted) {
            this.numberOfAssignmentsCompleted = numberOfAssignmentsCompleted;
        }

        public HIT build() {
            return new HIT(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HIT> {
        public Builder hitId(String var1);

        public Builder hitTypeId(String var1);

        public Builder hitGroupId(String var1);

        public Builder hitLayoutId(String var1);

        public Builder creationTime(Instant var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder question(String var1);

        public Builder keywords(String var1);

        public Builder hitStatus(String var1);

        public Builder hitStatus(HITStatus var1);

        public Builder maxAssignments(Integer var1);

        public Builder reward(String var1);

        public Builder autoApprovalDelayInSeconds(Long var1);

        public Builder expiration(Instant var1);

        public Builder assignmentDurationInSeconds(Long var1);

        public Builder requesterAnnotation(String var1);

        public Builder qualificationRequirements(Collection<QualificationRequirement> var1);

        public Builder qualificationRequirements(QualificationRequirement ... var1);

        public Builder qualificationRequirements(Consumer<QualificationRequirement.Builder> ... var1);

        public Builder hitReviewStatus(String var1);

        public Builder hitReviewStatus(HITReviewStatus var1);

        public Builder numberOfAssignmentsPending(Integer var1);

        public Builder numberOfAssignmentsAvailable(Integer var1);

        public Builder numberOfAssignmentsCompleted(Integer var1);
    }
}

