/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.model.AssignmentStatus;
import software.amazon.awssdk.services.mturk.transform.AssignmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Assignment
implements StructuredPojo,
ToCopyableBuilder<Builder, Assignment> {
    private final String assignmentId;
    private final String workerId;
    private final String hitId;
    private final String assignmentStatus;
    private final Instant autoApprovalTime;
    private final Instant acceptTime;
    private final Instant submitTime;
    private final Instant approvalTime;
    private final Instant rejectionTime;
    private final Instant deadline;
    private final String answer;
    private final String requesterFeedback;

    private Assignment(BuilderImpl builder) {
        this.assignmentId = builder.assignmentId;
        this.workerId = builder.workerId;
        this.hitId = builder.hitId;
        this.assignmentStatus = builder.assignmentStatus;
        this.autoApprovalTime = builder.autoApprovalTime;
        this.acceptTime = builder.acceptTime;
        this.submitTime = builder.submitTime;
        this.approvalTime = builder.approvalTime;
        this.rejectionTime = builder.rejectionTime;
        this.deadline = builder.deadline;
        this.answer = builder.answer;
        this.requesterFeedback = builder.requesterFeedback;
    }

    public String assignmentId() {
        return this.assignmentId;
    }

    public String workerId() {
        return this.workerId;
    }

    public String hitId() {
        return this.hitId;
    }

    public AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(this.assignmentStatus);
    }

    public String assignmentStatusAsString() {
        return this.assignmentStatus;
    }

    public Instant autoApprovalTime() {
        return this.autoApprovalTime;
    }

    public Instant acceptTime() {
        return this.acceptTime;
    }

    public Instant submitTime() {
        return this.submitTime;
    }

    public Instant approvalTime() {
        return this.approvalTime;
    }

    public Instant rejectionTime() {
        return this.rejectionTime;
    }

    public Instant deadline() {
        return this.deadline;
    }

    public String answer() {
        return this.answer;
    }

    public String requesterFeedback() {
        return this.requesterFeedback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoApprovalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadline());
        hashCode = 31 * hashCode + Objects.hashCode(this.answer());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterFeedback());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Assignment)) {
            return false;
        }
        Assignment other = (Assignment)obj;
        return Objects.equals(this.assignmentId(), other.assignmentId()) && Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.assignmentStatusAsString(), other.assignmentStatusAsString()) && Objects.equals(this.autoApprovalTime(), other.autoApprovalTime()) && Objects.equals(this.acceptTime(), other.acceptTime()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.approvalTime(), other.approvalTime()) && Objects.equals(this.rejectionTime(), other.rejectionTime()) && Objects.equals(this.deadline(), other.deadline()) && Objects.equals(this.answer(), other.answer()) && Objects.equals(this.requesterFeedback(), other.requesterFeedback());
    }

    public String toString() {
        return ToString.builder((String)"Assignment").add("AssignmentId", (Object)this.assignmentId()).add("WorkerId", (Object)this.workerId()).add("HITId", (Object)this.hitId()).add("AssignmentStatus", (Object)this.assignmentStatusAsString()).add("AutoApprovalTime", (Object)this.autoApprovalTime()).add("AcceptTime", (Object)this.acceptTime()).add("SubmitTime", (Object)this.submitTime()).add("ApprovalTime", (Object)this.approvalTime()).add("RejectionTime", (Object)this.rejectionTime()).add("Deadline", (Object)this.deadline()).add("Answer", (Object)this.answer()).add("RequesterFeedback", (Object)this.requesterFeedback()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentId": {
                return Optional.ofNullable(clazz.cast(this.assignmentId()));
            }
            case "WorkerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "AssignmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusAsString()));
            }
            case "AutoApprovalTime": {
                return Optional.ofNullable(clazz.cast(this.autoApprovalTime()));
            }
            case "AcceptTime": {
                return Optional.ofNullable(clazz.cast(this.acceptTime()));
            }
            case "SubmitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "ApprovalTime": {
                return Optional.ofNullable(clazz.cast(this.approvalTime()));
            }
            case "RejectionTime": {
                return Optional.ofNullable(clazz.cast(this.rejectionTime()));
            }
            case "Deadline": {
                return Optional.ofNullable(clazz.cast(this.deadline()));
            }
            case "Answer": {
                return Optional.ofNullable(clazz.cast(this.answer()));
            }
            case "RequesterFeedback": {
                return Optional.ofNullable(clazz.cast(this.requesterFeedback()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssignmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String assignmentId;
        private String workerId;
        private String hitId;
        private String assignmentStatus;
        private Instant autoApprovalTime;
        private Instant acceptTime;
        private Instant submitTime;
        private Instant approvalTime;
        private Instant rejectionTime;
        private Instant deadline;
        private String answer;
        private String requesterFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(Assignment model) {
            this.assignmentId(model.assignmentId);
            this.workerId(model.workerId);
            this.hitId(model.hitId);
            this.assignmentStatus(model.assignmentStatus);
            this.autoApprovalTime(model.autoApprovalTime);
            this.acceptTime(model.acceptTime);
            this.submitTime(model.submitTime);
            this.approvalTime(model.approvalTime);
            this.rejectionTime(model.rejectionTime);
            this.deadline(model.deadline);
            this.answer(model.answer);
            this.requesterFeedback(model.requesterFeedback);
        }

        public final String getAssignmentId() {
            return this.assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final String getHITId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus.toString());
            return this;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        public final Instant getAutoApprovalTime() {
            return this.autoApprovalTime;
        }

        @Override
        public final Builder autoApprovalTime(Instant autoApprovalTime) {
            this.autoApprovalTime = autoApprovalTime;
            return this;
        }

        public final void setAutoApprovalTime(Instant autoApprovalTime) {
            this.autoApprovalTime = autoApprovalTime;
        }

        public final Instant getAcceptTime() {
            return this.acceptTime;
        }

        @Override
        public final Builder acceptTime(Instant acceptTime) {
            this.acceptTime = acceptTime;
            return this;
        }

        public final void setAcceptTime(Instant acceptTime) {
            this.acceptTime = acceptTime;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        public final Instant getApprovalTime() {
            return this.approvalTime;
        }

        @Override
        public final Builder approvalTime(Instant approvalTime) {
            this.approvalTime = approvalTime;
            return this;
        }

        public final void setApprovalTime(Instant approvalTime) {
            this.approvalTime = approvalTime;
        }

        public final Instant getRejectionTime() {
            return this.rejectionTime;
        }

        @Override
        public final Builder rejectionTime(Instant rejectionTime) {
            this.rejectionTime = rejectionTime;
            return this;
        }

        public final void setRejectionTime(Instant rejectionTime) {
            this.rejectionTime = rejectionTime;
        }

        public final Instant getDeadline() {
            return this.deadline;
        }

        @Override
        public final Builder deadline(Instant deadline) {
            this.deadline = deadline;
            return this;
        }

        public final void setDeadline(Instant deadline) {
            this.deadline = deadline;
        }

        public final String getAnswer() {
            return this.answer;
        }

        @Override
        public final Builder answer(String answer) {
            this.answer = answer;
            return this;
        }

        public final void setAnswer(String answer) {
            this.answer = answer;
        }

        public final String getRequesterFeedback() {
            return this.requesterFeedback;
        }

        @Override
        public final Builder requesterFeedback(String requesterFeedback) {
            this.requesterFeedback = requesterFeedback;
            return this;
        }

        public final void setRequesterFeedback(String requesterFeedback) {
            this.requesterFeedback = requesterFeedback;
        }

        public Assignment build() {
            return new Assignment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Assignment> {
        public Builder assignmentId(String var1);

        public Builder workerId(String var1);

        public Builder hitId(String var1);

        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatus var1);

        public Builder autoApprovalTime(Instant var1);

        public Builder acceptTime(Instant var1);

        public Builder submitTime(Instant var1);

        public Builder approvalTime(Instant var1);

        public Builder rejectionTime(Instant var1);

        public Builder deadline(Instant var1);

        public Builder answer(String var1);

        public Builder requesterFeedback(String var1);
    }
}

