/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest;
import software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestResponse;
import software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.ApproveAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest;
import software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerResponse;
import software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest;
import software.amazon.awssdk.services.mturk.model.CreateWorkerBlockResponse;
import software.amazon.awssdk.services.mturk.model.DeleteHitRequest;
import software.amazon.awssdk.services.mturk.model.DeleteHitResponse;
import software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest;
import software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockResponse;
import software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest;
import software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerResponse;
import software.amazon.awssdk.services.mturk.model.GetAccountBalanceRequest;
import software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse;
import software.amazon.awssdk.services.mturk.model.GetAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.GetAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest;
import software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse;
import software.amazon.awssdk.services.mturk.model.GetHitRequest;
import software.amazon.awssdk.services.mturk.model.GetHitResponse;
import software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest;
import software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse;
import software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.ListHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsResponse;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse;
import software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.MTurkException;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse;
import software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.RejectAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest;
import software.amazon.awssdk.services.mturk.model.RejectQualificationRequestResponse;
import software.amazon.awssdk.services.mturk.model.RequestErrorException;
import software.amazon.awssdk.services.mturk.model.SendBonusRequest;
import software.amazon.awssdk.services.mturk.model.SendBonusResponse;
import software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest;
import software.amazon.awssdk.services.mturk.model.SendTestEventNotificationResponse;
import software.amazon.awssdk.services.mturk.model.ServiceException;
import software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest;
import software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitResponse;
import software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest;
import software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusResponse;
import software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest;
import software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitResponse;
import software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest;
import software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsResponse;
import software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.paginators.ListAssignmentsForHITIterable;
import software.amazon.awssdk.services.mturk.paginators.ListBonusPaymentsIterable;
import software.amazon.awssdk.services.mturk.paginators.ListHITsForQualificationTypeIterable;
import software.amazon.awssdk.services.mturk.paginators.ListHITsIterable;
import software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsIterable;
import software.amazon.awssdk.services.mturk.paginators.ListQualificationTypesIterable;
import software.amazon.awssdk.services.mturk.paginators.ListReviewPolicyResultsForHITIterable;
import software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsIterable;
import software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksIterable;
import software.amazon.awssdk.services.mturk.paginators.ListWorkersWithQualificationTypeIterable;
import software.amazon.awssdk.services.mturk.transform.AcceptQualificationRequestRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.AcceptQualificationRequestResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ApproveAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ApproveAssignmentResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.AssociateQualificationWithWorkerRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.AssociateQualificationWithWorkerResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateAdditionalAssignmentsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateAdditionalAssignmentsForHitResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitTypeResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitWithHitTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitWithHitTypeResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateQualificationTypeResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateWorkerBlockRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateWorkerBlockResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteHitResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteQualificationTypeResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteWorkerBlockRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteWorkerBlockResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.DisassociateQualificationFromWorkerRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DisassociateQualificationFromWorkerResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.GetAccountBalanceRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetAccountBalanceResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.GetAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetAssignmentResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.GetFileUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetFileUploadUrlResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.GetHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetHitResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.GetQualificationScoreRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetQualificationScoreResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.GetQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetQualificationTypeResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListAssignmentsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListAssignmentsForHitResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListBonusPaymentsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListBonusPaymentsResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListHiTsForQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListHiTsForQualificationTypeResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListHiTsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListHiTsResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListQualificationRequestsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListQualificationRequestsResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListQualificationTypesRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListQualificationTypesResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListReviewPolicyResultsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListReviewPolicyResultsForHitResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListReviewableHiTsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListReviewableHiTsResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListWorkerBlocksRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListWorkerBlocksResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.ListWorkersWithQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListWorkersWithQualificationTypeResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.NotifyWorkersRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.NotifyWorkersResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.RejectAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.RejectAssignmentResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.RejectQualificationRequestRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.RejectQualificationRequestResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.SendBonusRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.SendBonusResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.SendTestEventNotificationRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.SendTestEventNotificationResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateExpirationForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateExpirationForHitResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateHitReviewStatusRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateHitReviewStatusResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateHitTypeOfHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateHitTypeOfHitResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateNotificationSettingsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateNotificationSettingsResponseUnmarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateQualificationTypeResponseUnmarshaller;

@SdkInternalApi
final class DefaultMTurkClient
implements MTurkClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMTurkClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "mturk-requester";
    }

    @Override
    public AcceptQualificationRequestResponse acceptQualificationRequest(AcceptQualificationRequestRequest acceptQualificationRequestRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptQualificationRequestResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (AcceptQualificationRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptQualificationRequestRequest).withMarshaller((Marshaller)new AcceptQualificationRequestRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ApproveAssignmentResponse approveAssignment(ApproveAssignmentRequest approveAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ApproveAssignmentResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ApproveAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)approveAssignmentRequest).withMarshaller((Marshaller)new ApproveAssignmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AssociateQualificationWithWorkerResponse associateQualificationWithWorker(AssociateQualificationWithWorkerRequest associateQualificationWithWorkerRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateQualificationWithWorkerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (AssociateQualificationWithWorkerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateQualificationWithWorkerRequest).withMarshaller((Marshaller)new AssociateQualificationWithWorkerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateAdditionalAssignmentsForHitResponse createAdditionalAssignmentsForHIT(CreateAdditionalAssignmentsForHitRequest createAdditionalAssignmentsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAdditionalAssignmentsForHitResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateAdditionalAssignmentsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAdditionalAssignmentsForHitRequest).withMarshaller((Marshaller)new CreateAdditionalAssignmentsForHitRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateHitResponse createHIT(CreateHitRequest createHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHitResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateHitResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHitRequest).withMarshaller((Marshaller)new CreateHitRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateHitTypeResponse createHITType(CreateHitTypeRequest createHitTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHitTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateHitTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHitTypeRequest).withMarshaller((Marshaller)new CreateHitTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateHitWithHitTypeResponse createHITWithHITType(CreateHitWithHitTypeRequest createHitWithHitTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHitWithHitTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateHitWithHitTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHitWithHitTypeRequest).withMarshaller((Marshaller)new CreateHitWithHitTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateQualificationTypeResponse createQualificationType(CreateQualificationTypeRequest createQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateQualificationTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createQualificationTypeRequest).withMarshaller((Marshaller)new CreateQualificationTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateWorkerBlockResponse createWorkerBlock(CreateWorkerBlockRequest createWorkerBlockRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWorkerBlockResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateWorkerBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkerBlockRequest).withMarshaller((Marshaller)new CreateWorkerBlockRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteHitResponse deleteHIT(DeleteHitRequest deleteHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHitResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteHitResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHitRequest).withMarshaller((Marshaller)new DeleteHitRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteQualificationTypeResponse deleteQualificationType(DeleteQualificationTypeRequest deleteQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteQualificationTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteQualificationTypeRequest).withMarshaller((Marshaller)new DeleteQualificationTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteWorkerBlockResponse deleteWorkerBlock(DeleteWorkerBlockRequest deleteWorkerBlockRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteWorkerBlockResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteWorkerBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkerBlockRequest).withMarshaller((Marshaller)new DeleteWorkerBlockRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisassociateQualificationFromWorkerResponse disassociateQualificationFromWorker(DisassociateQualificationFromWorkerRequest disassociateQualificationFromWorkerRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateQualificationFromWorkerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DisassociateQualificationFromWorkerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateQualificationFromWorkerRequest).withMarshaller((Marshaller)new DisassociateQualificationFromWorkerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAccountBalanceResponse getAccountBalance(GetAccountBalanceRequest getAccountBalanceRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAccountBalanceResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetAccountBalanceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountBalanceRequest).withMarshaller((Marshaller)new GetAccountBalanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAssignmentResponse getAssignment(GetAssignmentRequest getAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAssignmentResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAssignmentRequest).withMarshaller((Marshaller)new GetAssignmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFileUploadUrlResponse getFileUploadURL(GetFileUploadUrlRequest getFileUploadUrlRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFileUploadUrlResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetFileUploadUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFileUploadUrlRequest).withMarshaller((Marshaller)new GetFileUploadUrlRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetHitResponse getHIT(GetHitRequest getHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetHitResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetHitResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHitRequest).withMarshaller((Marshaller)new GetHitRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetQualificationScoreResponse getQualificationScore(GetQualificationScoreRequest getQualificationScoreRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQualificationScoreResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetQualificationScoreResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQualificationScoreRequest).withMarshaller((Marshaller)new GetQualificationScoreRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetQualificationTypeResponse getQualificationType(GetQualificationTypeRequest getQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQualificationTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQualificationTypeRequest).withMarshaller((Marshaller)new GetQualificationTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListAssignmentsForHitResponse listAssignmentsForHIT(ListAssignmentsForHitRequest listAssignmentsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssignmentsForHitResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListAssignmentsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAssignmentsForHitRequest).withMarshaller((Marshaller)new ListAssignmentsForHitRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListAssignmentsForHITIterable listAssignmentsForHITPaginator(ListAssignmentsForHitRequest listAssignmentsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListAssignmentsForHITIterable(this, this.applyPaginatorUserAgent(listAssignmentsForHitRequest));
    }

    @Override
    public ListBonusPaymentsResponse listBonusPayments(ListBonusPaymentsRequest listBonusPaymentsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBonusPaymentsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListBonusPaymentsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBonusPaymentsRequest).withMarshaller((Marshaller)new ListBonusPaymentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListBonusPaymentsIterable listBonusPaymentsPaginator(ListBonusPaymentsRequest listBonusPaymentsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListBonusPaymentsIterable(this, this.applyPaginatorUserAgent(listBonusPaymentsRequest));
    }

    @Override
    public ListHiTsResponse listHITs(ListHiTsRequest listHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHiTsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListHiTsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHiTsRequest).withMarshaller((Marshaller)new ListHiTsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListHITsIterable listHITsPaginator(ListHiTsRequest listHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListHITsIterable(this, this.applyPaginatorUserAgent(listHiTsRequest));
    }

    @Override
    public ListHiTsForQualificationTypeResponse listHITsForQualificationType(ListHiTsForQualificationTypeRequest listHiTsForQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHiTsForQualificationTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListHiTsForQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHiTsForQualificationTypeRequest).withMarshaller((Marshaller)new ListHiTsForQualificationTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListHITsForQualificationTypeIterable listHITsForQualificationTypePaginator(ListHiTsForQualificationTypeRequest listHiTsForQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListHITsForQualificationTypeIterable(this, this.applyPaginatorUserAgent(listHiTsForQualificationTypeRequest));
    }

    @Override
    public ListQualificationRequestsResponse listQualificationRequests(ListQualificationRequestsRequest listQualificationRequestsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQualificationRequestsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListQualificationRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQualificationRequestsRequest).withMarshaller((Marshaller)new ListQualificationRequestsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListQualificationRequestsIterable listQualificationRequestsPaginator(ListQualificationRequestsRequest listQualificationRequestsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListQualificationRequestsIterable(this, this.applyPaginatorUserAgent(listQualificationRequestsRequest));
    }

    @Override
    public ListQualificationTypesResponse listQualificationTypes(ListQualificationTypesRequest listQualificationTypesRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQualificationTypesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListQualificationTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQualificationTypesRequest).withMarshaller((Marshaller)new ListQualificationTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListQualificationTypesIterable listQualificationTypesPaginator(ListQualificationTypesRequest listQualificationTypesRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListQualificationTypesIterable(this, this.applyPaginatorUserAgent(listQualificationTypesRequest));
    }

    @Override
    public ListReviewPolicyResultsForHitResponse listReviewPolicyResultsForHIT(ListReviewPolicyResultsForHitRequest listReviewPolicyResultsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReviewPolicyResultsForHitResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListReviewPolicyResultsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReviewPolicyResultsForHitRequest).withMarshaller((Marshaller)new ListReviewPolicyResultsForHitRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListReviewPolicyResultsForHITIterable listReviewPolicyResultsForHITPaginator(ListReviewPolicyResultsForHitRequest listReviewPolicyResultsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListReviewPolicyResultsForHITIterable(this, this.applyPaginatorUserAgent(listReviewPolicyResultsForHitRequest));
    }

    @Override
    public ListReviewableHiTsResponse listReviewableHITs(ListReviewableHiTsRequest listReviewableHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReviewableHiTsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListReviewableHiTsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReviewableHiTsRequest).withMarshaller((Marshaller)new ListReviewableHiTsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListReviewableHITsIterable listReviewableHITsPaginator(ListReviewableHiTsRequest listReviewableHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListReviewableHITsIterable(this, this.applyPaginatorUserAgent(listReviewableHiTsRequest));
    }

    @Override
    public ListWorkerBlocksResponse listWorkerBlocks(ListWorkerBlocksRequest listWorkerBlocksRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkerBlocksResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListWorkerBlocksResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkerBlocksRequest).withMarshaller((Marshaller)new ListWorkerBlocksRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListWorkerBlocksIterable listWorkerBlocksPaginator(ListWorkerBlocksRequest listWorkerBlocksRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListWorkerBlocksIterable(this, this.applyPaginatorUserAgent(listWorkerBlocksRequest));
    }

    @Override
    public ListWorkersWithQualificationTypeResponse listWorkersWithQualificationType(ListWorkersWithQualificationTypeRequest listWorkersWithQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkersWithQualificationTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListWorkersWithQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkersWithQualificationTypeRequest).withMarshaller((Marshaller)new ListWorkersWithQualificationTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListWorkersWithQualificationTypeIterable listWorkersWithQualificationTypePaginator(ListWorkersWithQualificationTypeRequest listWorkersWithQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListWorkersWithQualificationTypeIterable(this, this.applyPaginatorUserAgent(listWorkersWithQualificationTypeRequest));
    }

    @Override
    public NotifyWorkersResponse notifyWorkers(NotifyWorkersRequest notifyWorkersRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new NotifyWorkersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (NotifyWorkersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyWorkersRequest).withMarshaller((Marshaller)new NotifyWorkersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RejectAssignmentResponse rejectAssignment(RejectAssignmentRequest rejectAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RejectAssignmentResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (RejectAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectAssignmentRequest).withMarshaller((Marshaller)new RejectAssignmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RejectQualificationRequestResponse rejectQualificationRequest(RejectQualificationRequestRequest rejectQualificationRequestRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RejectQualificationRequestResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (RejectQualificationRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectQualificationRequestRequest).withMarshaller((Marshaller)new RejectQualificationRequestRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendBonusResponse sendBonus(SendBonusRequest sendBonusRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendBonusResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SendBonusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendBonusRequest).withMarshaller((Marshaller)new SendBonusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendTestEventNotificationResponse sendTestEventNotification(SendTestEventNotificationRequest sendTestEventNotificationRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendTestEventNotificationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SendTestEventNotificationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendTestEventNotificationRequest).withMarshaller((Marshaller)new SendTestEventNotificationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateExpirationForHitResponse updateExpirationForHIT(UpdateExpirationForHitRequest updateExpirationForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateExpirationForHitResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateExpirationForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateExpirationForHitRequest).withMarshaller((Marshaller)new UpdateExpirationForHitRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateHitReviewStatusResponse updateHITReviewStatus(UpdateHitReviewStatusRequest updateHitReviewStatusRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateHitReviewStatusResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateHitReviewStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateHitReviewStatusRequest).withMarshaller((Marshaller)new UpdateHitReviewStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateHitTypeOfHitResponse updateHITTypeOfHIT(UpdateHitTypeOfHitRequest updateHitTypeOfHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateHitTypeOfHitResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateHitTypeOfHitResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateHitTypeOfHitRequest).withMarshaller((Marshaller)new UpdateHitTypeOfHitRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateNotificationSettingsResponse updateNotificationSettings(UpdateNotificationSettingsRequest updateNotificationSettingsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNotificationSettingsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateNotificationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNotificationSettingsRequest).withMarshaller((Marshaller)new UpdateNotificationSettingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateQualificationTypeResponse updateQualificationType(UpdateQualificationTypeRequest updateQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateQualificationTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateQualificationTypeRequest).withMarshaller((Marshaller)new UpdateQualificationTypeRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(MTurkException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFault").withModeledClass(ServiceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestError").withModeledClass(RequestErrorException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends MTurkRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MTurkRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

