/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.DayOfWeek;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WeeklyStartTime
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WeeklyStartTime> {
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WeeklyStartTime.getter(WeeklyStartTime::dayOfWeekAsString)).setter(WeeklyStartTime.setter(Builder::dayOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfWeek").build()}).build();
    private static final SdkField<String> TIME_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WeeklyStartTime.getter(WeeklyStartTime::timeOfDay)).setter(WeeklyStartTime.setter(Builder::timeOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOfDay").build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WeeklyStartTime.getter(WeeklyStartTime::timeZone)).setter(WeeklyStartTime.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_WEEK_FIELD, TIME_OF_DAY_FIELD, TIME_ZONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dayOfWeek;
    private final String timeOfDay;
    private final String timeZone;

    private WeeklyStartTime(BuilderImpl builder) {
        this.dayOfWeek = builder.dayOfWeek;
        this.timeOfDay = builder.timeOfDay;
        this.timeZone = builder.timeZone;
    }

    public DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(this.dayOfWeek);
    }

    public String dayOfWeekAsString() {
        return this.dayOfWeek;
    }

    public String timeOfDay() {
        return this.timeOfDay;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklyStartTime)) {
            return false;
        }
        WeeklyStartTime other = (WeeklyStartTime)obj;
        return Objects.equals(this.dayOfWeekAsString(), other.dayOfWeekAsString()) && Objects.equals(this.timeOfDay(), other.timeOfDay()) && Objects.equals(this.timeZone(), other.timeZone());
    }

    public String toString() {
        return ToString.builder((String)"WeeklyStartTime").add("DayOfWeek", (Object)this.dayOfWeekAsString()).add("TimeOfDay", (Object)this.timeOfDay()).add("TimeZone", (Object)this.timeZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeekAsString()));
            }
            case "TimeOfDay": {
                return Optional.ofNullable(clazz.cast(this.timeOfDay()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeeklyStartTime, T> g) {
        return obj -> g.apply((WeeklyStartTime)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dayOfWeek;
        private String timeOfDay;
        private String timeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklyStartTime model) {
            this.dayOfWeek(model.dayOfWeek);
            this.timeOfDay(model.timeOfDay);
            this.timeZone(model.timeZone);
        }

        public final String getDayOfWeekAsString() {
            return this.dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public final String getTimeOfDay() {
            return this.timeOfDay;
        }

        @Override
        public final Builder timeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
            return this;
        }

        public final void setTimeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public WeeklyStartTime build() {
            return new WeeklyStartTime(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WeeklyStartTime> {
        public Builder dayOfWeek(String var1);

        public Builder dayOfWeek(DayOfWeek var1);

        public Builder timeOfDay(String var1);

        public Builder timeZone(String var1);
    }
}

