/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteConfigurationRequest
extends MqRequest
implements ToCopyableBuilder<Builder, DeleteConfigurationRequest> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationId").getter(DeleteConfigurationRequest.getter(DeleteConfigurationRequest::configurationId)).setter(DeleteConfigurationRequest.setter(Builder::configurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuration-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteConfigurationRequest.memberNameToFieldInitializer();
    private final String configurationId;

    private DeleteConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
    }

    public final String configurationId() {
        return this.configurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigurationRequest)) {
            return false;
        }
        DeleteConfigurationRequest other = (DeleteConfigurationRequest)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteConfigurationRequest").add("ConfigurationId", (Object)this.configurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("configuration-id", CONFIGURATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqRequest.BuilderImpl
    implements Builder {
        private String configurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigurationRequest model) {
            super(model);
            this.configurationId(model.configurationId);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConfigurationRequest build() {
            return new DeleteConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MqRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteConfigurationRequest> {
        public Builder configurationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

