/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends MqRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerId").getter(UpdateUserRequest.getter(UpdateUserRequest::brokerId)).setter(UpdateUserRequest.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("broker-id").build()}).build();
    private static final SdkField<Boolean> CONSOLE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConsoleAccess").getter(UpdateUserRequest.getter(UpdateUserRequest::consoleAccess)).setter(UpdateUserRequest.setter(Builder::consoleAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleAccess").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(UpdateUserRequest.getter(UpdateUserRequest::groups)).setter(UpdateUserRequest.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(UpdateUserRequest.getter(UpdateUserRequest::password)).setter(UpdateUserRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(UpdateUserRequest.getter(UpdateUserRequest::username)).setter(UpdateUserRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("username").build()}).build();
    private static final SdkField<Boolean> REPLICATION_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReplicationUser").getter(UpdateUserRequest.getter(UpdateUserRequest::replicationUser)).setter(UpdateUserRequest.setter(Builder::replicationUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationUser").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ID_FIELD, CONSOLE_ACCESS_FIELD, GROUPS_FIELD, PASSWORD_FIELD, USERNAME_FIELD, REPLICATION_USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUserRequest.memberNameToFieldInitializer();
    private final String brokerId;
    private final Boolean consoleAccess;
    private final List<String> groups;
    private final String password;
    private final String username;
    private final Boolean replicationUser;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.password = builder.password;
        this.username = builder.username;
        this.replicationUser = builder.replicationUser;
    }

    public final String brokerId() {
        return this.brokerId;
    }

    public final Boolean consoleAccess() {
        return this.consoleAccess;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final String password() {
        return this.password;
    }

    public final String username() {
        return this.username;
    }

    public final Boolean replicationUser() {
        return this.replicationUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationUser());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.consoleAccess(), other.consoleAccess()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.replicationUser(), other.replicationUser());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("BrokerId", (Object)this.brokerId()).add("ConsoleAccess", (Object)this.consoleAccess()).add("Groups", this.hasGroups() ? this.groups() : null).add("Password", (Object)this.password()).add("Username", (Object)this.username()).add("ReplicationUser", (Object)this.replicationUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "ConsoleAccess": {
                return Optional.ofNullable(clazz.cast(this.consoleAccess()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "ReplicationUser": {
                return Optional.ofNullable(clazz.cast(this.replicationUser()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("broker-id", BROKER_ID_FIELD);
        map.put("consoleAccess", CONSOLE_ACCESS_FIELD);
        map.put("groups", GROUPS_FIELD);
        map.put("password", PASSWORD_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("replicationUser", REPLICATION_USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqRequest.BuilderImpl
    implements Builder {
        private String brokerId;
        private Boolean consoleAccess;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String password;
        private String username;
        private Boolean replicationUser;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.brokerId(model.brokerId);
            this.consoleAccess(model.consoleAccess);
            this.groups(model.groups);
            this.password(model.password);
            this.username(model.username);
            this.replicationUser(model.replicationUser);
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final Boolean getConsoleAccess() {
            return this.consoleAccess;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Boolean getReplicationUser() {
            return this.replicationUser;
        }

        public final void setReplicationUser(Boolean replicationUser) {
            this.replicationUser = replicationUser;
        }

        @Override
        public final Builder replicationUser(Boolean replicationUser) {
            this.replicationUser = replicationUser;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MqRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder brokerId(String var1);

        public Builder consoleAccess(Boolean var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder password(String var1);

        public Builder username(String var1);

        public Builder replicationUser(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

