/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.AvailabilityZone;
import software.amazon.awssdk.services.mq.model.BrokerStorageType;
import software.amazon.awssdk.services.mq.model.DeploymentMode;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.___listOfAvailabilityZoneCopier;
import software.amazon.awssdk.services.mq.model.___listOfDeploymentModeCopier;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerInstanceOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerInstanceOption> {
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(BrokerInstanceOption.getter(BrokerInstanceOption::availabilityZones)).setter(BrokerInstanceOption.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineType").getter(BrokerInstanceOption.getter(BrokerInstanceOption::engineTypeAsString)).setter(BrokerInstanceOption.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostInstanceType").getter(BrokerInstanceOption.getter(BrokerInstanceOption::hostInstanceType)).setter(BrokerInstanceOption.setter(Builder::hostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(BrokerInstanceOption.getter(BrokerInstanceOption::storageTypeAsString)).setter(BrokerInstanceOption.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_DEPLOYMENT_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedDeploymentModes").getter(BrokerInstanceOption.getter(BrokerInstanceOption::supportedDeploymentModesAsStrings)).setter(BrokerInstanceOption.setter(Builder::supportedDeploymentModesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDeploymentModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedEngineVersions").getter(BrokerInstanceOption.getter(BrokerInstanceOption::supportedEngineVersions)).setter(BrokerInstanceOption.setter(Builder::supportedEngineVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEngineVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, ENGINE_TYPE_FIELD, HOST_INSTANCE_TYPE_FIELD, STORAGE_TYPE_FIELD, SUPPORTED_DEPLOYMENT_MODES_FIELD, SUPPORTED_ENGINE_VERSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AvailabilityZone> availabilityZones;
    private final String engineType;
    private final String hostInstanceType;
    private final String storageType;
    private final List<String> supportedDeploymentModes;
    private final List<String> supportedEngineVersions;

    private BrokerInstanceOption(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.engineType = builder.engineType;
        this.hostInstanceType = builder.hostInstanceType;
        this.storageType = builder.storageType;
        this.supportedDeploymentModes = builder.supportedDeploymentModes;
        this.supportedEngineVersions = builder.supportedEngineVersions;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public final EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final String hostInstanceType() {
        return this.hostInstanceType;
    }

    public final BrokerStorageType storageType() {
        return BrokerStorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final List<DeploymentMode> supportedDeploymentModes() {
        return ___listOfDeploymentModeCopier.copyStringToEnum(this.supportedDeploymentModes);
    }

    public final boolean hasSupportedDeploymentModes() {
        return this.supportedDeploymentModes != null && !(this.supportedDeploymentModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedDeploymentModesAsStrings() {
        return this.supportedDeploymentModes;
    }

    public final boolean hasSupportedEngineVersions() {
        return this.supportedEngineVersions != null && !(this.supportedEngineVersions instanceof SdkAutoConstructList);
    }

    public final List<String> supportedEngineVersions() {
        return this.supportedEngineVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedDeploymentModes() ? this.supportedDeploymentModesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedEngineVersions() ? this.supportedEngineVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstanceOption)) {
            return false;
        }
        BrokerInstanceOption other = (BrokerInstanceOption)obj;
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && this.hasSupportedDeploymentModes() == other.hasSupportedDeploymentModes() && Objects.equals(this.supportedDeploymentModesAsStrings(), other.supportedDeploymentModesAsStrings()) && this.hasSupportedEngineVersions() == other.hasSupportedEngineVersions() && Objects.equals(this.supportedEngineVersions(), other.supportedEngineVersions());
    }

    public final String toString() {
        return ToString.builder((String)"BrokerInstanceOption").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("EngineType", (Object)this.engineTypeAsString()).add("HostInstanceType", (Object)this.hostInstanceType()).add("StorageType", (Object)this.storageTypeAsString()).add("SupportedDeploymentModes", this.hasSupportedDeploymentModes() ? this.supportedDeploymentModesAsStrings() : null).add("SupportedEngineVersions", this.hasSupportedEngineVersions() ? this.supportedEngineVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "HostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.hostInstanceType()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "SupportedDeploymentModes": {
                return Optional.ofNullable(clazz.cast(this.supportedDeploymentModesAsStrings()));
            }
            case "SupportedEngineVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedEngineVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerInstanceOption, T> g) {
        return obj -> g.apply((BrokerInstanceOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String engineType;
        private String hostInstanceType;
        private String storageType;
        private List<String> supportedDeploymentModes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedEngineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerInstanceOption model) {
            this.availabilityZones(model.availabilityZones);
            this.engineType(model.engineType);
            this.hostInstanceType(model.hostInstanceType);
            this.storageType(model.storageType);
            this.supportedDeploymentModesWithStrings(model.supportedDeploymentModes);
            this.supportedEngineVersions(model.supportedEngineVersions);
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = ___listOfAvailabilityZoneCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = ___listOfAvailabilityZoneCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = ___listOfAvailabilityZoneCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(BrokerStorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Collection<String> getSupportedDeploymentModes() {
            if (this.supportedDeploymentModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedDeploymentModes;
        }

        public final void setSupportedDeploymentModes(Collection<String> supportedDeploymentModes) {
            this.supportedDeploymentModes = ___listOfDeploymentModeCopier.copy(supportedDeploymentModes);
        }

        @Override
        public final Builder supportedDeploymentModesWithStrings(Collection<String> supportedDeploymentModes) {
            this.supportedDeploymentModes = ___listOfDeploymentModeCopier.copy(supportedDeploymentModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDeploymentModesWithStrings(String ... supportedDeploymentModes) {
            this.supportedDeploymentModesWithStrings(Arrays.asList(supportedDeploymentModes));
            return this;
        }

        @Override
        public final Builder supportedDeploymentModes(Collection<DeploymentMode> supportedDeploymentModes) {
            this.supportedDeploymentModes = ___listOfDeploymentModeCopier.copyEnumToString(supportedDeploymentModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDeploymentModes(DeploymentMode ... supportedDeploymentModes) {
            this.supportedDeploymentModes(Arrays.asList(supportedDeploymentModes));
            return this;
        }

        public final Collection<String> getSupportedEngineVersions() {
            if (this.supportedEngineVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedEngineVersions;
        }

        public final void setSupportedEngineVersions(Collection<String> supportedEngineVersions) {
            this.supportedEngineVersions = ___listOf__stringCopier.copy(supportedEngineVersions);
        }

        @Override
        public final Builder supportedEngineVersions(Collection<String> supportedEngineVersions) {
            this.supportedEngineVersions = ___listOf__stringCopier.copy(supportedEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineVersions(String ... supportedEngineVersions) {
            this.supportedEngineVersions(Arrays.asList(supportedEngineVersions));
            return this;
        }

        public BrokerInstanceOption build() {
            return new BrokerInstanceOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerInstanceOption> {
        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder hostInstanceType(String var1);

        public Builder storageType(String var1);

        public Builder storageType(BrokerStorageType var1);

        public Builder supportedDeploymentModesWithStrings(Collection<String> var1);

        public Builder supportedDeploymentModesWithStrings(String ... var1);

        public Builder supportedDeploymentModes(Collection<DeploymentMode> var1);

        public Builder supportedDeploymentModes(DeploymentMode ... var1);

        public Builder supportedEngineVersions(Collection<String> var1);

        public Builder supportedEngineVersions(String ... var1);
    }
}

