/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mq.DefaultMqAsyncClient;
import software.amazon.awssdk.services.mq.DefaultMqBaseClientBuilder;
import software.amazon.awssdk.services.mq.MqAsyncClient;
import software.amazon.awssdk.services.mq.MqAsyncClientBuilder;
import software.amazon.awssdk.services.mq.MqServiceClientConfiguration;
import software.amazon.awssdk.services.mq.endpoints.MqEndpointProvider;

@SdkInternalApi
final class DefaultMqAsyncClientBuilder
extends DefaultMqBaseClientBuilder<MqAsyncClientBuilder, MqAsyncClient>
implements MqAsyncClientBuilder {
    DefaultMqAsyncClientBuilder() {
    }

    @Override
    public DefaultMqAsyncClientBuilder endpointProvider(MqEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MqAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMqAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MqServiceClientConfiguration serviceClientConfiguration = MqServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultMqAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

