/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LdapServerMetadataInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LdapServerMetadataInput> {
    private static final SdkField<List<String>> HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Hosts").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::hosts)).setter(LdapServerMetadataInput.setter(Builder::hosts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hosts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleBase").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::roleBase)).setter(LdapServerMetadataInput.setter(Builder::roleBase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleBase").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::roleName)).setter(LdapServerMetadataInput.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()}).build();
    private static final SdkField<String> ROLE_SEARCH_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleSearchMatching").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::roleSearchMatching)).setter(LdapServerMetadataInput.setter(Builder::roleSearchMatching)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleSearchMatching").build()}).build();
    private static final SdkField<Boolean> ROLE_SEARCH_SUBTREE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RoleSearchSubtree").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::roleSearchSubtree)).setter(LdapServerMetadataInput.setter(Builder::roleSearchSubtree)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleSearchSubtree").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccountPassword").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::serviceAccountPassword)).setter(LdapServerMetadataInput.setter(Builder::serviceAccountPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountPassword").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccountUsername").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::serviceAccountUsername)).setter(LdapServerMetadataInput.setter(Builder::serviceAccountUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountUsername").build()}).build();
    private static final SdkField<String> USER_BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserBase").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::userBase)).setter(LdapServerMetadataInput.setter(Builder::userBase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userBase").build()}).build();
    private static final SdkField<String> USER_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserRoleName").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::userRoleName)).setter(LdapServerMetadataInput.setter(Builder::userRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRoleName").build()}).build();
    private static final SdkField<String> USER_SEARCH_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserSearchMatching").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::userSearchMatching)).setter(LdapServerMetadataInput.setter(Builder::userSearchMatching)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSearchMatching").build()}).build();
    private static final SdkField<Boolean> USER_SEARCH_SUBTREE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserSearchSubtree").getter(LdapServerMetadataInput.getter(LdapServerMetadataInput::userSearchSubtree)).setter(LdapServerMetadataInput.setter(Builder::userSearchSubtree)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSearchSubtree").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTS_FIELD, ROLE_BASE_FIELD, ROLE_NAME_FIELD, ROLE_SEARCH_MATCHING_FIELD, ROLE_SEARCH_SUBTREE_FIELD, SERVICE_ACCOUNT_PASSWORD_FIELD, SERVICE_ACCOUNT_USERNAME_FIELD, USER_BASE_FIELD, USER_ROLE_NAME_FIELD, USER_SEARCH_MATCHING_FIELD, USER_SEARCH_SUBTREE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> hosts;
    private final String roleBase;
    private final String roleName;
    private final String roleSearchMatching;
    private final Boolean roleSearchSubtree;
    private final String serviceAccountPassword;
    private final String serviceAccountUsername;
    private final String userBase;
    private final String userRoleName;
    private final String userSearchMatching;
    private final Boolean userSearchSubtree;

    private LdapServerMetadataInput(BuilderImpl builder) {
        this.hosts = builder.hosts;
        this.roleBase = builder.roleBase;
        this.roleName = builder.roleName;
        this.roleSearchMatching = builder.roleSearchMatching;
        this.roleSearchSubtree = builder.roleSearchSubtree;
        this.serviceAccountPassword = builder.serviceAccountPassword;
        this.serviceAccountUsername = builder.serviceAccountUsername;
        this.userBase = builder.userBase;
        this.userRoleName = builder.userRoleName;
        this.userSearchMatching = builder.userSearchMatching;
        this.userSearchSubtree = builder.userSearchSubtree;
    }

    public final boolean hasHosts() {
        return this.hosts != null && !(this.hosts instanceof SdkAutoConstructList);
    }

    public final List<String> hosts() {
        return this.hosts;
    }

    public final String roleBase() {
        return this.roleBase;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final String roleSearchMatching() {
        return this.roleSearchMatching;
    }

    public final Boolean roleSearchSubtree() {
        return this.roleSearchSubtree;
    }

    public final String serviceAccountPassword() {
        return this.serviceAccountPassword;
    }

    public final String serviceAccountUsername() {
        return this.serviceAccountUsername;
    }

    public final String userBase() {
        return this.userBase;
    }

    public final String userRoleName() {
        return this.userRoleName;
    }

    public final String userSearchMatching() {
        return this.userSearchMatching;
    }

    public final Boolean userSearchSubtree() {
        return this.userSearchSubtree;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHosts() ? this.hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleBase());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleSearchSubtree());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.userBase());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSearchSubtree());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LdapServerMetadataInput)) {
            return false;
        }
        LdapServerMetadataInput other = (LdapServerMetadataInput)obj;
        return this.hasHosts() == other.hasHosts() && Objects.equals(this.hosts(), other.hosts()) && Objects.equals(this.roleBase(), other.roleBase()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.roleSearchMatching(), other.roleSearchMatching()) && Objects.equals(this.roleSearchSubtree(), other.roleSearchSubtree()) && Objects.equals(this.serviceAccountPassword(), other.serviceAccountPassword()) && Objects.equals(this.serviceAccountUsername(), other.serviceAccountUsername()) && Objects.equals(this.userBase(), other.userBase()) && Objects.equals(this.userRoleName(), other.userRoleName()) && Objects.equals(this.userSearchMatching(), other.userSearchMatching()) && Objects.equals(this.userSearchSubtree(), other.userSearchSubtree());
    }

    public final String toString() {
        return ToString.builder((String)"LdapServerMetadataInput").add("Hosts", this.hasHosts() ? this.hosts() : null).add("RoleBase", (Object)this.roleBase()).add("RoleName", (Object)this.roleName()).add("RoleSearchMatching", (Object)this.roleSearchMatching()).add("RoleSearchSubtree", (Object)this.roleSearchSubtree()).add("ServiceAccountPassword", (Object)this.serviceAccountPassword()).add("ServiceAccountUsername", (Object)this.serviceAccountUsername()).add("UserBase", (Object)this.userBase()).add("UserRoleName", (Object)this.userRoleName()).add("UserSearchMatching", (Object)this.userSearchMatching()).add("UserSearchSubtree", (Object)this.userSearchSubtree()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Hosts": {
                return Optional.ofNullable(clazz.cast(this.hosts()));
            }
            case "RoleBase": {
                return Optional.ofNullable(clazz.cast(this.roleBase()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "RoleSearchMatching": {
                return Optional.ofNullable(clazz.cast(this.roleSearchMatching()));
            }
            case "RoleSearchSubtree": {
                return Optional.ofNullable(clazz.cast(this.roleSearchSubtree()));
            }
            case "ServiceAccountPassword": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountPassword()));
            }
            case "ServiceAccountUsername": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountUsername()));
            }
            case "UserBase": {
                return Optional.ofNullable(clazz.cast(this.userBase()));
            }
            case "UserRoleName": {
                return Optional.ofNullable(clazz.cast(this.userRoleName()));
            }
            case "UserSearchMatching": {
                return Optional.ofNullable(clazz.cast(this.userSearchMatching()));
            }
            case "UserSearchSubtree": {
                return Optional.ofNullable(clazz.cast(this.userSearchSubtree()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LdapServerMetadataInput, T> g) {
        return obj -> g.apply((LdapServerMetadataInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> hosts = DefaultSdkAutoConstructList.getInstance();
        private String roleBase;
        private String roleName;
        private String roleSearchMatching;
        private Boolean roleSearchSubtree;
        private String serviceAccountPassword;
        private String serviceAccountUsername;
        private String userBase;
        private String userRoleName;
        private String userSearchMatching;
        private Boolean userSearchSubtree;

        private BuilderImpl() {
        }

        private BuilderImpl(LdapServerMetadataInput model) {
            this.hosts(model.hosts);
            this.roleBase(model.roleBase);
            this.roleName(model.roleName);
            this.roleSearchMatching(model.roleSearchMatching);
            this.roleSearchSubtree(model.roleSearchSubtree);
            this.serviceAccountPassword(model.serviceAccountPassword);
            this.serviceAccountUsername(model.serviceAccountUsername);
            this.userBase(model.userBase);
            this.userRoleName(model.userRoleName);
            this.userSearchMatching(model.userSearchMatching);
            this.userSearchSubtree(model.userSearchSubtree);
        }

        public final Collection<String> getHosts() {
            if (this.hosts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hosts;
        }

        @Override
        public final Builder hosts(Collection<String> hosts) {
            this.hosts = ___listOf__stringCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(String ... hosts) {
            this.hosts(Arrays.asList(hosts));
            return this;
        }

        public final void setHosts(Collection<String> hosts) {
            this.hosts = ___listOf__stringCopier.copy(hosts);
        }

        public final String getRoleBase() {
            return this.roleBase;
        }

        @Override
        public final Builder roleBase(String roleBase) {
            this.roleBase = roleBase;
            return this;
        }

        public final void setRoleBase(String roleBase) {
            this.roleBase = roleBase;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleSearchMatching() {
            return this.roleSearchMatching;
        }

        @Override
        public final Builder roleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
            return this;
        }

        public final void setRoleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
        }

        public final Boolean getRoleSearchSubtree() {
            return this.roleSearchSubtree;
        }

        @Override
        public final Builder roleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
            return this;
        }

        public final void setRoleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
        }

        public final String getServiceAccountPassword() {
            return this.serviceAccountPassword;
        }

        @Override
        public final Builder serviceAccountPassword(String serviceAccountPassword) {
            this.serviceAccountPassword = serviceAccountPassword;
            return this;
        }

        public final void setServiceAccountPassword(String serviceAccountPassword) {
            this.serviceAccountPassword = serviceAccountPassword;
        }

        public final String getServiceAccountUsername() {
            return this.serviceAccountUsername;
        }

        @Override
        public final Builder serviceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
            return this;
        }

        public final void setServiceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
        }

        public final String getUserBase() {
            return this.userBase;
        }

        @Override
        public final Builder userBase(String userBase) {
            this.userBase = userBase;
            return this;
        }

        public final void setUserBase(String userBase) {
            this.userBase = userBase;
        }

        public final String getUserRoleName() {
            return this.userRoleName;
        }

        @Override
        public final Builder userRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
            return this;
        }

        public final void setUserRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
        }

        public final String getUserSearchMatching() {
            return this.userSearchMatching;
        }

        @Override
        public final Builder userSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
            return this;
        }

        public final void setUserSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
        }

        public final Boolean getUserSearchSubtree() {
            return this.userSearchSubtree;
        }

        @Override
        public final Builder userSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
            return this;
        }

        public final void setUserSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
        }

        public LdapServerMetadataInput build() {
            return new LdapServerMetadataInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LdapServerMetadataInput> {
        public Builder hosts(Collection<String> var1);

        public Builder hosts(String ... var1);

        public Builder roleBase(String var1);

        public Builder roleName(String var1);

        public Builder roleSearchMatching(String var1);

        public Builder roleSearchSubtree(Boolean var1);

        public Builder serviceAccountPassword(String var1);

        public Builder serviceAccountUsername(String var1);

        public Builder userBase(String var1);

        public Builder userRoleName(String var1);

        public Builder userSearchMatching(String var1);

        public Builder userSearchSubtree(Boolean var1);
    }
}

