/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.ConfigurationRevision;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.services.mq.model.SanitizationWarning;
import software.amazon.awssdk.services.mq.model.___listOfSanitizationWarningCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfigurationResponse
extends MqResponse
implements ToCopyableBuilder<Builder, UpdateConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateConfigurationResponse.getter(UpdateConfigurationResponse::arn)).setter(UpdateConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(UpdateConfigurationResponse.getter(UpdateConfigurationResponse::created)).setter(UpdateConfigurationResponse.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateConfigurationResponse.getter(UpdateConfigurationResponse::id)).setter(UpdateConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestRevision").getter(UpdateConfigurationResponse.getter(UpdateConfigurationResponse::latestRevision)).setter(UpdateConfigurationResponse.setter(Builder::latestRevision)).constructor(ConfigurationRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateConfigurationResponse.getter(UpdateConfigurationResponse::name)).setter(UpdateConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<SanitizationWarning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(UpdateConfigurationResponse.getter(UpdateConfigurationResponse::warnings)).setter(UpdateConfigurationResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SanitizationWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_FIELD, ID_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, WARNINGS_FIELD));
    private final String arn;
    private final Instant created;
    private final String id;
    private final ConfigurationRevision latestRevision;
    private final String name;
    private final List<SanitizationWarning> warnings;

    private UpdateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.created = builder.created;
        this.id = builder.id;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.warnings = builder.warnings;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant created() {
        return this.created;
    }

    public final String id() {
        return this.id;
    }

    public final ConfigurationRevision latestRevision() {
        return this.latestRevision;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<SanitizationWarning> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationResponse)) {
            return false;
        }
        UpdateConfigurationResponse other = (UpdateConfigurationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.latestRevision(), other.latestRevision()) && Objects.equals(this.name(), other.name()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConfigurationResponse").add("Arn", (Object)this.arn()).add("Created", (Object)this.created()).add("Id", (Object)this.id()).add("LatestRevision", (Object)this.latestRevision()).add("Name", (Object)this.name()).add("Warnings", this.hasWarnings() ? this.warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LatestRevision": {
                return Optional.ofNullable(clazz.cast(this.latestRevision()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant created;
        private String id;
        private ConfigurationRevision latestRevision;
        private String name;
        private List<SanitizationWarning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationResponse model) {
            super(model);
            this.arn(model.arn);
            this.created(model.created);
            this.id(model.id);
            this.latestRevision(model.latestRevision);
            this.name(model.name);
            this.warnings(model.warnings);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return this.latestRevision != null ? this.latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        @Transient
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<SanitizationWarning.Builder> getWarnings() {
            List<SanitizationWarning.Builder> result = ___listOfSanitizationWarningCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<SanitizationWarning.BuilderImpl> warnings) {
            this.warnings = ___listOfSanitizationWarningCopier.copyFromBuilder(warnings);
        }

        @Override
        @Transient
        public final Builder warnings(Collection<SanitizationWarning> warnings) {
            this.warnings = ___listOfSanitizationWarningCopier.copy(warnings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder warnings(SanitizationWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder warnings(Consumer<SanitizationWarning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (SanitizationWarning)((SanitizationWarning.Builder)SanitizationWarning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateConfigurationResponse build() {
            return new UpdateConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfigurationResponse> {
        public Builder arn(String var1);

        public Builder created(Instant var1);

        public Builder id(String var1);

        public Builder latestRevision(ConfigurationRevision var1);

        default public Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return this.latestRevision((ConfigurationRevision)((ConfigurationRevision.Builder)ConfigurationRevision.builder().applyMutation(latestRevision)).build());
        }

        public Builder name(String var1);

        public Builder warnings(Collection<SanitizationWarning> var1);

        public Builder warnings(SanitizationWarning ... var1);

        public Builder warnings(Consumer<SanitizationWarning.Builder> ... var1);
    }
}

