/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.BrokerEngineType;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.services.mq.model.___listOfBrokerEngineTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBrokerEngineTypesResponse
extends MqResponse
implements ToCopyableBuilder<Builder, DescribeBrokerEngineTypesResponse> {
    private static final SdkField<List<BrokerEngineType>> BROKER_ENGINE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BrokerEngineTypes").getter(DescribeBrokerEngineTypesResponse.getter(DescribeBrokerEngineTypesResponse::brokerEngineTypes)).setter(DescribeBrokerEngineTypesResponse.setter(Builder::brokerEngineTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerEngineTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrokerEngineType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeBrokerEngineTypesResponse.getter(DescribeBrokerEngineTypesResponse::maxResults)).setter(DescribeBrokerEngineTypesResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeBrokerEngineTypesResponse.getter(DescribeBrokerEngineTypesResponse::nextToken)).setter(DescribeBrokerEngineTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ENGINE_TYPES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BrokerEngineType> brokerEngineTypes;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeBrokerEngineTypesResponse(BuilderImpl builder) {
        super(builder);
        this.brokerEngineTypes = builder.brokerEngineTypes;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public boolean hasBrokerEngineTypes() {
        return this.brokerEngineTypes != null && !(this.brokerEngineTypes instanceof SdkAutoConstructList);
    }

    public List<BrokerEngineType> brokerEngineTypes() {
        return this.brokerEngineTypes;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBrokerEngineTypes() ? this.brokerEngineTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerEngineTypesResponse)) {
            return false;
        }
        DescribeBrokerEngineTypesResponse other = (DescribeBrokerEngineTypesResponse)((Object)obj);
        return this.hasBrokerEngineTypes() == other.hasBrokerEngineTypes() && Objects.equals(this.brokerEngineTypes(), other.brokerEngineTypes()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBrokerEngineTypesResponse").add("BrokerEngineTypes", this.hasBrokerEngineTypes() ? this.brokerEngineTypes() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerEngineTypes": {
                return Optional.ofNullable(clazz.cast(this.brokerEngineTypes()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerEngineTypesResponse, T> g) {
        return obj -> g.apply((DescribeBrokerEngineTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private List<BrokerEngineType> brokerEngineTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerEngineTypesResponse model) {
            super(model);
            this.brokerEngineTypes(model.brokerEngineTypes);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<BrokerEngineType.Builder> getBrokerEngineTypes() {
            if (this.brokerEngineTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.brokerEngineTypes != null ? (Collection)this.brokerEngineTypes.stream().map(BrokerEngineType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder brokerEngineTypes(Collection<BrokerEngineType> brokerEngineTypes) {
            this.brokerEngineTypes = ___listOfBrokerEngineTypeCopier.copy(brokerEngineTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEngineTypes(BrokerEngineType ... brokerEngineTypes) {
            this.brokerEngineTypes(Arrays.asList(brokerEngineTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEngineTypes(Consumer<BrokerEngineType.Builder> ... brokerEngineTypes) {
            this.brokerEngineTypes(Stream.of(brokerEngineTypes).map(c -> (BrokerEngineType)((BrokerEngineType.Builder)BrokerEngineType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerEngineTypes(Collection<BrokerEngineType.BuilderImpl> brokerEngineTypes) {
            this.brokerEngineTypes = ___listOfBrokerEngineTypeCopier.copyFromBuilder(brokerEngineTypes);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBrokerEngineTypesResponse build() {
            return new DescribeBrokerEngineTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBrokerEngineTypesResponse> {
        public Builder brokerEngineTypes(Collection<BrokerEngineType> var1);

        public Builder brokerEngineTypes(BrokerEngineType ... var1);

        public Builder brokerEngineTypes(Consumer<BrokerEngineType.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

