/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.PendingLogs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogsSummary> {
    private static final SdkField<Boolean> AUDIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Audit").getter(LogsSummary.getter(LogsSummary::audit)).setter(LogsSummary.setter(Builder::audit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audit").build()}).build();
    private static final SdkField<String> AUDIT_LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditLogGroup").getter(LogsSummary.getter(LogsSummary::auditLogGroup)).setter(LogsSummary.setter(Builder::auditLogGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditLogGroup").build()}).build();
    private static final SdkField<Boolean> GENERAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("General").getter(LogsSummary.getter(LogsSummary::general)).setter(LogsSummary.setter(Builder::general)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("general").build()}).build();
    private static final SdkField<String> GENERAL_LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneralLogGroup").getter(LogsSummary.getter(LogsSummary::generalLogGroup)).setter(LogsSummary.setter(Builder::generalLogGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generalLogGroup").build()}).build();
    private static final SdkField<PendingLogs> PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pending").getter(LogsSummary.getter(LogsSummary::pending)).setter(LogsSummary.setter(Builder::pending)).constructor(PendingLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_FIELD, AUDIT_LOG_GROUP_FIELD, GENERAL_FIELD, GENERAL_LOG_GROUP_FIELD, PENDING_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean audit;
    private final String auditLogGroup;
    private final Boolean general;
    private final String generalLogGroup;
    private final PendingLogs pending;

    private LogsSummary(BuilderImpl builder) {
        this.audit = builder.audit;
        this.auditLogGroup = builder.auditLogGroup;
        this.general = builder.general;
        this.generalLogGroup = builder.generalLogGroup;
        this.pending = builder.pending;
    }

    public Boolean audit() {
        return this.audit;
    }

    public String auditLogGroup() {
        return this.auditLogGroup;
    }

    public Boolean general() {
        return this.general;
    }

    public String generalLogGroup() {
        return this.generalLogGroup;
    }

    public PendingLogs pending() {
        return this.pending;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audit());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.general());
        hashCode = 31 * hashCode + Objects.hashCode(this.generalLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsSummary)) {
            return false;
        }
        LogsSummary other = (LogsSummary)obj;
        return Objects.equals(this.audit(), other.audit()) && Objects.equals(this.auditLogGroup(), other.auditLogGroup()) && Objects.equals(this.general(), other.general()) && Objects.equals(this.generalLogGroup(), other.generalLogGroup()) && Objects.equals(this.pending(), other.pending());
    }

    public String toString() {
        return ToString.builder((String)"LogsSummary").add("Audit", (Object)this.audit()).add("AuditLogGroup", (Object)this.auditLogGroup()).add("General", (Object)this.general()).add("GeneralLogGroup", (Object)this.generalLogGroup()).add("Pending", (Object)this.pending()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Audit": {
                return Optional.ofNullable(clazz.cast(this.audit()));
            }
            case "AuditLogGroup": {
                return Optional.ofNullable(clazz.cast(this.auditLogGroup()));
            }
            case "General": {
                return Optional.ofNullable(clazz.cast(this.general()));
            }
            case "GeneralLogGroup": {
                return Optional.ofNullable(clazz.cast(this.generalLogGroup()));
            }
            case "Pending": {
                return Optional.ofNullable(clazz.cast(this.pending()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogsSummary, T> g) {
        return obj -> g.apply((LogsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean audit;
        private String auditLogGroup;
        private Boolean general;
        private String generalLogGroup;
        private PendingLogs pending;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsSummary model) {
            this.audit(model.audit);
            this.auditLogGroup(model.auditLogGroup);
            this.general(model.general);
            this.generalLogGroup(model.generalLogGroup);
            this.pending(model.pending);
        }

        public final Boolean getAudit() {
            return this.audit;
        }

        @Override
        public final Builder audit(Boolean audit) {
            this.audit = audit;
            return this;
        }

        public final void setAudit(Boolean audit) {
            this.audit = audit;
        }

        public final String getAuditLogGroup() {
            return this.auditLogGroup;
        }

        @Override
        public final Builder auditLogGroup(String auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
            return this;
        }

        public final void setAuditLogGroup(String auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
        }

        public final Boolean getGeneral() {
            return this.general;
        }

        @Override
        public final Builder general(Boolean general) {
            this.general = general;
            return this;
        }

        public final void setGeneral(Boolean general) {
            this.general = general;
        }

        public final String getGeneralLogGroup() {
            return this.generalLogGroup;
        }

        @Override
        public final Builder generalLogGroup(String generalLogGroup) {
            this.generalLogGroup = generalLogGroup;
            return this;
        }

        public final void setGeneralLogGroup(String generalLogGroup) {
            this.generalLogGroup = generalLogGroup;
        }

        public final PendingLogs.Builder getPending() {
            return this.pending != null ? this.pending.toBuilder() : null;
        }

        @Override
        public final Builder pending(PendingLogs pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(PendingLogs.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        public LogsSummary build() {
            return new LogsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogsSummary> {
        public Builder audit(Boolean var1);

        public Builder auditLogGroup(String var1);

        public Builder general(Boolean var1);

        public Builder generalLogGroup(String var1);

        public Builder pending(PendingLogs var1);

        default public Builder pending(Consumer<PendingLogs.Builder> pending) {
            return this.pending((PendingLogs)((PendingLogs.Builder)PendingLogs.builder().applyMutation(pending)).build());
        }
    }
}

