/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SanitizationWarningReason {
    DISALLOWED_ELEMENT_REMOVED("DISALLOWED_ELEMENT_REMOVED"),
    DISALLOWED_ATTRIBUTE_REMOVED("DISALLOWED_ATTRIBUTE_REMOVED"),
    INVALID_ATTRIBUTE_VALUE_REMOVED("INVALID_ATTRIBUTE_VALUE_REMOVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SanitizationWarningReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SanitizationWarningReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SanitizationWarningReason.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SanitizationWarningReason> knownValues() {
        return Stream.of(SanitizationWarningReason.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

