/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AuthenticationStrategy {
    SIMPLE("SIMPLE"),
    LDAP("LDAP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AuthenticationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AuthenticationStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationStrategy> knownValues() {
        return Stream.of(AuthenticationStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

