/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BrokerState {
    CREATION_IN_PROGRESS("CREATION_IN_PROGRESS"),
    CREATION_FAILED("CREATION_FAILED"),
    DELETION_IN_PROGRESS("DELETION_IN_PROGRESS"),
    RUNNING("RUNNING"),
    REBOOT_IN_PROGRESS("REBOOT_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BrokerState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrokerState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BrokerState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrokerState> knownValues() {
        return Stream.of(BrokerState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

