/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.mq.model.BrokerInstance;
import software.amazon.awssdk.services.mq.model.BrokerState;
import software.amazon.awssdk.services.mq.model.Configurations;
import software.amazon.awssdk.services.mq.model.DeploymentMode;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.LogsSummary;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.services.mq.model.UserSummary;
import software.amazon.awssdk.services.mq.model.WeeklyStartTime;
import software.amazon.awssdk.services.mq.model.___listOfBrokerInstanceCopier;
import software.amazon.awssdk.services.mq.model.___listOfUserSummaryCopier;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.services.mq.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBrokerResponse
extends MqResponse
implements ToCopyableBuilder<Builder, DescribeBrokerResponse> {
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::autoMinorVersionUpgrade)).setter(DescribeBrokerResponse.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> BROKER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerArn)).setter(DescribeBrokerResponse.setter(Builder::brokerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerArn").build()}).build();
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerId)).setter(DescribeBrokerResponse.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()}).build();
    private static final SdkField<List<BrokerInstance>> BROKER_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerInstances)).setter(DescribeBrokerResponse.setter(Builder::brokerInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrokerInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BROKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerName)).setter(DescribeBrokerResponse.setter(Builder::brokerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerName").build()}).build();
    private static final SdkField<String> BROKER_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerStateAsString)).setter(DescribeBrokerResponse.setter(Builder::brokerState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerState").build()}).build();
    private static final SdkField<Configurations> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::configurations)).setter(DescribeBrokerResponse.setter(Builder::configurations)).constructor(Configurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::created)).setter(DescribeBrokerResponse.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::deploymentModeAsString)).setter(DescribeBrokerResponse.setter(Builder::deploymentMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::engineTypeAsString)).setter(DescribeBrokerResponse.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::engineVersion)).setter(DescribeBrokerResponse.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::hostInstanceType)).setter(DescribeBrokerResponse.setter(Builder::hostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()}).build();
    private static final SdkField<LogsSummary> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::logs)).setter(DescribeBrokerResponse.setter(Builder::logs)).constructor(LogsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final SdkField<WeeklyStartTime> MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::maintenanceWindowStartTime)).setter(DescribeBrokerResponse.setter(Builder::maintenanceWindowStartTime)).constructor(WeeklyStartTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindowStartTime").build()}).build();
    private static final SdkField<String> PENDING_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::pendingEngineVersion)).setter(DescribeBrokerResponse.setter(Builder::pendingEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingEngineVersion").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::publiclyAccessible)).setter(DescribeBrokerResponse.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::securityGroups)).setter(DescribeBrokerResponse.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::subnetIds)).setter(DescribeBrokerResponse.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::tags)).setter(DescribeBrokerResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<UserSummary>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::users)).setter(DescribeBrokerResponse.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ARN_FIELD, BROKER_ID_FIELD, BROKER_INSTANCES_FIELD, BROKER_NAME_FIELD, BROKER_STATE_FIELD, CONFIGURATIONS_FIELD, CREATED_FIELD, DEPLOYMENT_MODE_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, HOST_INSTANCE_TYPE_FIELD, LOGS_FIELD, MAINTENANCE_WINDOW_START_TIME_FIELD, PENDING_ENGINE_VERSION_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUPS_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, USERS_FIELD));
    private final Boolean autoMinorVersionUpgrade;
    private final String brokerArn;
    private final String brokerId;
    private final List<BrokerInstance> brokerInstances;
    private final String brokerName;
    private final String brokerState;
    private final Configurations configurations;
    private final Instant created;
    private final String deploymentMode;
    private final String engineType;
    private final String engineVersion;
    private final String hostInstanceType;
    private final LogsSummary logs;
    private final WeeklyStartTime maintenanceWindowStartTime;
    private final String pendingEngineVersion;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroups;
    private final List<String> subnetIds;
    private final Map<String, String> tags;
    private final List<UserSummary> users;

    private DescribeBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerArn = builder.brokerArn;
        this.brokerId = builder.brokerId;
        this.brokerInstances = builder.brokerInstances;
        this.brokerName = builder.brokerName;
        this.brokerState = builder.brokerState;
        this.configurations = builder.configurations;
        this.created = builder.created;
        this.deploymentMode = builder.deploymentMode;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.logs = builder.logs;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.pendingEngineVersion = builder.pendingEngineVersion;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroups = builder.securityGroups;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.users = builder.users;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String brokerArn() {
        return this.brokerArn;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public List<BrokerInstance> brokerInstances() {
        return this.brokerInstances;
    }

    public String brokerName() {
        return this.brokerName;
    }

    public BrokerState brokerState() {
        return BrokerState.fromValue(this.brokerState);
    }

    public String brokerStateAsString() {
        return this.brokerState;
    }

    public Configurations configurations() {
        return this.configurations;
    }

    public Instant created() {
        return this.created;
    }

    public DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(this.deploymentMode);
    }

    public String deploymentModeAsString() {
        return this.deploymentMode;
    }

    public EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public String engineTypeAsString() {
        return this.engineType;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String hostInstanceType() {
        return this.hostInstanceType;
    }

    public LogsSummary logs() {
        return this.logs;
    }

    public WeeklyStartTime maintenanceWindowStartTime() {
        return this.maintenanceWindowStartTime;
    }

    public String pendingEngineVersion() {
        return this.pendingEngineVersion;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public List<UserSummary> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerResponse)) {
            return false;
        }
        DescribeBrokerResponse other = (DescribeBrokerResponse)((Object)obj);
        return Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.brokerArn(), other.brokerArn()) && Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.brokerInstances(), other.brokerInstances()) && Objects.equals(this.brokerName(), other.brokerName()) && Objects.equals(this.brokerStateAsString(), other.brokerStateAsString()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.deploymentModeAsString(), other.deploymentModeAsString()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.maintenanceWindowStartTime(), other.maintenanceWindowStartTime()) && Objects.equals(this.pendingEngineVersion(), other.pendingEngineVersion()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.users(), other.users());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBrokerResponse").add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("BrokerArn", (Object)this.brokerArn()).add("BrokerId", (Object)this.brokerId()).add("BrokerInstances", this.brokerInstances()).add("BrokerName", (Object)this.brokerName()).add("BrokerState", (Object)this.brokerStateAsString()).add("Configurations", (Object)this.configurations()).add("Created", (Object)this.created()).add("DeploymentMode", (Object)this.deploymentModeAsString()).add("EngineType", (Object)this.engineTypeAsString()).add("EngineVersion", (Object)this.engineVersion()).add("HostInstanceType", (Object)this.hostInstanceType()).add("Logs", (Object)this.logs()).add("MaintenanceWindowStartTime", (Object)this.maintenanceWindowStartTime()).add("PendingEngineVersion", (Object)this.pendingEngineVersion()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroups", this.securityGroups()).add("SubnetIds", this.subnetIds()).add("Tags", this.tags()).add("Users", this.users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "BrokerArn": {
                return Optional.ofNullable(clazz.cast(this.brokerArn()));
            }
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "BrokerInstances": {
                return Optional.ofNullable(clazz.cast(this.brokerInstances()));
            }
            case "BrokerName": {
                return Optional.ofNullable(clazz.cast(this.brokerName()));
            }
            case "BrokerState": {
                return Optional.ofNullable(clazz.cast(this.brokerStateAsString()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "DeploymentMode": {
                return Optional.ofNullable(clazz.cast(this.deploymentModeAsString()));
            }
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "HostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.hostInstanceType()));
            }
            case "Logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "MaintenanceWindowStartTime": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindowStartTime()));
            }
            case "PendingEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.pendingEngineVersion()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerResponse, T> g) {
        return obj -> g.apply((DescribeBrokerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private Boolean autoMinorVersionUpgrade;
        private String brokerArn;
        private String brokerId;
        private List<BrokerInstance> brokerInstances = DefaultSdkAutoConstructList.getInstance();
        private String brokerName;
        private String brokerState;
        private Configurations configurations;
        private Instant created;
        private String deploymentMode;
        private String engineType;
        private String engineVersion;
        private String hostInstanceType;
        private LogsSummary logs;
        private WeeklyStartTime maintenanceWindowStartTime;
        private String pendingEngineVersion;
        private Boolean publiclyAccessible;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<UserSummary> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerResponse model) {
            super(model);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.brokerArn(model.brokerArn);
            this.brokerId(model.brokerId);
            this.brokerInstances(model.brokerInstances);
            this.brokerName(model.brokerName);
            this.brokerState(model.brokerState);
            this.configurations(model.configurations);
            this.created(model.created);
            this.deploymentMode(model.deploymentMode);
            this.engineType(model.engineType);
            this.engineVersion(model.engineVersion);
            this.hostInstanceType(model.hostInstanceType);
            this.logs(model.logs);
            this.maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            this.pendingEngineVersion(model.pendingEngineVersion);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroups(model.securityGroups);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
            this.users(model.users);
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getBrokerArn() {
            return this.brokerArn;
        }

        @Override
        public final Builder brokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        public final void setBrokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final Collection<BrokerInstance.Builder> getBrokerInstances() {
            return this.brokerInstances != null ? (Collection)this.brokerInstances.stream().map(BrokerInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder brokerInstances(Collection<BrokerInstance> brokerInstances) {
            this.brokerInstances = ___listOfBrokerInstanceCopier.copy(brokerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstances(BrokerInstance ... brokerInstances) {
            this.brokerInstances(Arrays.asList(brokerInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstances(Consumer<BrokerInstance.Builder> ... brokerInstances) {
            this.brokerInstances(Stream.of(brokerInstances).map(c -> (BrokerInstance)((BrokerInstance.Builder)BrokerInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerInstances(Collection<BrokerInstance.BuilderImpl> brokerInstances) {
            this.brokerInstances = ___listOfBrokerInstanceCopier.copyFromBuilder(brokerInstances);
        }

        public final String getBrokerName() {
            return this.brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public final String getBrokerState() {
            return this.brokerState;
        }

        @Override
        public final Builder brokerState(String brokerState) {
            this.brokerState = brokerState;
            return this;
        }

        @Override
        public final Builder brokerState(BrokerState brokerState) {
            this.brokerState(brokerState.toString());
            return this;
        }

        public final void setBrokerState(String brokerState) {
            this.brokerState = brokerState;
        }

        public final Configurations.Builder getConfigurations() {
            return this.configurations != null ? this.configurations.toBuilder() : null;
        }

        @Override
        public final Builder configurations(Configurations configurations) {
            this.configurations = configurations;
            return this;
        }

        public final void setConfigurations(Configurations.BuilderImpl configurations) {
            this.configurations = configurations != null ? configurations.build() : null;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getDeploymentMode() {
            return this.deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode.toString());
            return this;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        public final LogsSummary.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(LogsSummary logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(LogsSummary.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return this.maintenanceWindowStartTime != null ? this.maintenanceWindowStartTime.toBuilder() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        public final String getPendingEngineVersion() {
            return this.pendingEngineVersion;
        }

        @Override
        public final Builder pendingEngineVersion(String pendingEngineVersion) {
            this.pendingEngineVersion = pendingEngineVersion;
            return this;
        }

        public final void setPendingEngineVersion(String pendingEngineVersion) {
            this.pendingEngineVersion = pendingEngineVersion;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final Collection<UserSummary.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(UserSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<UserSummary> users) {
            this.users = ___listOfUserSummaryCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserSummary ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserSummary.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserSummary)((UserSummary.Builder)UserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<UserSummary.BuilderImpl> users) {
            this.users = ___listOfUserSummaryCopier.copyFromBuilder(users);
        }

        @Override
        public DescribeBrokerResponse build() {
            return new DescribeBrokerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBrokerResponse> {
        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder brokerArn(String var1);

        public Builder brokerId(String var1);

        public Builder brokerInstances(Collection<BrokerInstance> var1);

        public Builder brokerInstances(BrokerInstance ... var1);

        public Builder brokerInstances(Consumer<BrokerInstance.Builder> ... var1);

        public Builder brokerName(String var1);

        public Builder brokerState(String var1);

        public Builder brokerState(BrokerState var1);

        public Builder configurations(Configurations var1);

        default public Builder configurations(Consumer<Configurations.Builder> configurations) {
            return this.configurations((Configurations)((Configurations.Builder)Configurations.builder().applyMutation(configurations)).build());
        }

        public Builder created(Instant var1);

        public Builder deploymentMode(String var1);

        public Builder deploymentMode(DeploymentMode var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder engineVersion(String var1);

        public Builder hostInstanceType(String var1);

        public Builder logs(LogsSummary var1);

        default public Builder logs(Consumer<LogsSummary.Builder> logs) {
            return this.logs((LogsSummary)((LogsSummary.Builder)LogsSummary.builder().applyMutation(logs)).build());
        }

        public Builder maintenanceWindowStartTime(WeeklyStartTime var1);

        default public Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return this.maintenanceWindowStartTime((WeeklyStartTime)((WeeklyStartTime.Builder)WeeklyStartTime.builder().applyMutation(maintenanceWindowStartTime)).build());
        }

        public Builder pendingEngineVersion(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder users(Collection<UserSummary> var1);

        public Builder users(UserSummary ... var1);

        public Builder users(Consumer<UserSummary.Builder> ... var1);
    }
}

