/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mq.DefaultMqClientBuilder;
import software.amazon.awssdk.services.mq.MqClientBuilder;
import software.amazon.awssdk.services.mq.model.BadRequestException;
import software.amazon.awssdk.services.mq.model.ConflictException;
import software.amazon.awssdk.services.mq.model.CreateBrokerRequest;
import software.amazon.awssdk.services.mq.model.CreateBrokerResponse;
import software.amazon.awssdk.services.mq.model.CreateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.CreateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.CreateUserRequest;
import software.amazon.awssdk.services.mq.model.CreateUserResponse;
import software.amazon.awssdk.services.mq.model.DeleteBrokerRequest;
import software.amazon.awssdk.services.mq.model.DeleteBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeleteUserRequest;
import software.amazon.awssdk.services.mq.model.DeleteUserResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionResponse;
import software.amazon.awssdk.services.mq.model.DescribeUserRequest;
import software.amazon.awssdk.services.mq.model.DescribeUserResponse;
import software.amazon.awssdk.services.mq.model.ForbiddenException;
import software.amazon.awssdk.services.mq.model.InternalServerErrorException;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.mq.model.ListUsersRequest;
import software.amazon.awssdk.services.mq.model.ListUsersResponse;
import software.amazon.awssdk.services.mq.model.MqException;
import software.amazon.awssdk.services.mq.model.NotFoundException;
import software.amazon.awssdk.services.mq.model.RebootBrokerRequest;
import software.amazon.awssdk.services.mq.model.RebootBrokerResponse;
import software.amazon.awssdk.services.mq.model.UnauthorizedException;
import software.amazon.awssdk.services.mq.model.UpdateBrokerRequest;
import software.amazon.awssdk.services.mq.model.UpdateBrokerResponse;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.UpdateUserRequest;
import software.amazon.awssdk.services.mq.model.UpdateUserResponse;

public interface MqClient
extends SdkClient {
    public static final String SERVICE_NAME = "mq";

    public static MqClient create() {
        return (MqClient)MqClient.builder().build();
    }

    public static MqClientBuilder builder() {
        return new DefaultMqClientBuilder();
    }

    default public CreateBrokerResponse createBroker(CreateBrokerRequest createBrokerRequest) throws BadRequestException, UnauthorizedException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public CreateBrokerResponse createBroker(Consumer<CreateBrokerRequest.Builder> createBrokerRequest) throws BadRequestException, UnauthorizedException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.createBroker((CreateBrokerRequest)((Object)((CreateBrokerRequest.Builder)CreateBrokerRequest.builder().applyMutation(createBrokerRequest)).build()));
    }

    default public CreateConfigurationResponse createConfiguration(CreateConfigurationRequest createConfigurationRequest) throws BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public CreateConfigurationResponse createConfiguration(Consumer<CreateConfigurationRequest.Builder> createConfigurationRequest) throws BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.createConfiguration((CreateConfigurationRequest)((Object)((CreateConfigurationRequest.Builder)CreateConfigurationRequest.builder().applyMutation(createConfigurationRequest)).build()));
    }

    default public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.createUser((CreateUserRequest)((Object)((CreateUserRequest.Builder)CreateUserRequest.builder().applyMutation(createUserRequest)).build()));
    }

    default public DeleteBrokerResponse deleteBroker(DeleteBrokerRequest deleteBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public DeleteBrokerResponse deleteBroker(Consumer<DeleteBrokerRequest.Builder> deleteBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.deleteBroker((DeleteBrokerRequest)((Object)((DeleteBrokerRequest.Builder)DeleteBrokerRequest.builder().applyMutation(deleteBrokerRequest)).build()));
    }

    default public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.deleteUser((DeleteUserRequest)((Object)((DeleteUserRequest.Builder)DeleteUserRequest.builder().applyMutation(deleteUserRequest)).build()));
    }

    default public DescribeBrokerResponse describeBroker(DescribeBrokerRequest describeBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public DescribeBrokerResponse describeBroker(Consumer<DescribeBrokerRequest.Builder> describeBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.describeBroker((DescribeBrokerRequest)((Object)((DescribeBrokerRequest.Builder)DescribeBrokerRequest.builder().applyMutation(describeBrokerRequest)).build()));
    }

    default public DescribeConfigurationResponse describeConfiguration(DescribeConfigurationRequest describeConfigurationRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public DescribeConfigurationResponse describeConfiguration(Consumer<DescribeConfigurationRequest.Builder> describeConfigurationRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.describeConfiguration((DescribeConfigurationRequest)((Object)((DescribeConfigurationRequest.Builder)DescribeConfigurationRequest.builder().applyMutation(describeConfigurationRequest)).build()));
    }

    default public DescribeConfigurationRevisionResponse describeConfigurationRevision(DescribeConfigurationRevisionRequest describeConfigurationRevisionRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public DescribeConfigurationRevisionResponse describeConfigurationRevision(Consumer<DescribeConfigurationRevisionRequest.Builder> describeConfigurationRevisionRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.describeConfigurationRevision((DescribeConfigurationRevisionRequest)((Object)((DescribeConfigurationRevisionRequest.Builder)DescribeConfigurationRevisionRequest.builder().applyMutation(describeConfigurationRevisionRequest)).build()));
    }

    default public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public DescribeUserResponse describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.describeUser((DescribeUserRequest)((Object)((DescribeUserRequest.Builder)DescribeUserRequest.builder().applyMutation(describeUserRequest)).build()));
    }

    default public ListBrokersResponse listBrokers() throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.listBrokers((ListBrokersRequest)((Object)ListBrokersRequest.builder().build()));
    }

    default public ListBrokersResponse listBrokers(ListBrokersRequest listBrokersRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public ListBrokersResponse listBrokers(Consumer<ListBrokersRequest.Builder> listBrokersRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.listBrokers((ListBrokersRequest)((Object)((ListBrokersRequest.Builder)ListBrokersRequest.builder().applyMutation(listBrokersRequest)).build()));
    }

    default public ListConfigurationRevisionsResponse listConfigurationRevisions(ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public ListConfigurationRevisionsResponse listConfigurationRevisions(Consumer<ListConfigurationRevisionsRequest.Builder> listConfigurationRevisionsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.listConfigurationRevisions((ListConfigurationRevisionsRequest)((Object)((ListConfigurationRevisionsRequest.Builder)ListConfigurationRevisionsRequest.builder().applyMutation(listConfigurationRevisionsRequest)).build()));
    }

    default public ListConfigurationsResponse listConfigurations() throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.listConfigurations((ListConfigurationsRequest)((Object)ListConfigurationsRequest.builder().build()));
    }

    default public ListConfigurationsResponse listConfigurations(ListConfigurationsRequest listConfigurationsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public ListConfigurationsResponse listConfigurations(Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.listConfigurations((ListConfigurationsRequest)((Object)((ListConfigurationsRequest.Builder)ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest)).build()));
    }

    default public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.listUsers((ListUsersRequest)((Object)((ListUsersRequest.Builder)ListUsersRequest.builder().applyMutation(listUsersRequest)).build()));
    }

    default public RebootBrokerResponse rebootBroker(RebootBrokerRequest rebootBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public RebootBrokerResponse rebootBroker(Consumer<RebootBrokerRequest.Builder> rebootBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.rebootBroker((RebootBrokerRequest)((Object)((RebootBrokerRequest.Builder)RebootBrokerRequest.builder().applyMutation(rebootBrokerRequest)).build()));
    }

    default public UpdateBrokerResponse updateBroker(UpdateBrokerRequest updateBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public UpdateBrokerResponse updateBroker(Consumer<UpdateBrokerRequest.Builder> updateBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.updateBroker((UpdateBrokerRequest)((Object)((UpdateBrokerRequest.Builder)UpdateBrokerRequest.builder().applyMutation(updateBrokerRequest)).build()));
    }

    default public UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest updateConfigurationRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public UpdateConfigurationResponse updateConfiguration(Consumer<UpdateConfigurationRequest.Builder> updateConfigurationRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.updateConfiguration((UpdateConfigurationRequest)((Object)((UpdateConfigurationRequest.Builder)UpdateConfigurationRequest.builder().applyMutation(updateConfigurationRequest)).build()));
    }

    default public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        throw new UnsupportedOperationException();
    }

    default public UpdateUserResponse updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return this.updateUser((UpdateUserRequest)((Object)((UpdateUserRequest.Builder)UpdateUserRequest.builder().applyMutation(updateUserRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

