/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.WeeklyStartTime;

@SdkInternalApi
public class WeeklyStartTimeMarshaller {
    private static final MarshallingInfo<String> DAYOFWEEK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dayOfWeek").build();
    private static final MarshallingInfo<String> TIMEOFDAY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeOfDay").build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeZone").build();
    private static final WeeklyStartTimeMarshaller INSTANCE = new WeeklyStartTimeMarshaller();

    public static WeeklyStartTimeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WeeklyStartTime weeklyStartTime, ProtocolMarshaller protocolMarshaller) {
        if (weeklyStartTime == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)weeklyStartTime.dayOfWeekString(), DAYOFWEEK_BINDING);
            protocolMarshaller.marshall((Object)weeklyStartTime.timeOfDay(), TIMEOFDAY_BINDING);
            protocolMarshaller.marshall((Object)weeklyStartTime.timeZone(), TIMEZONE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

