/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.CreateUserRequest;

@SdkInternalApi
public class CreateUserRequestModelMarshaller {
    private static final MarshallingInfo<String> BROKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("broker-id").build();
    private static final MarshallingInfo<Boolean> CONSOLEACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("consoleAccess").build();
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groups").build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("password").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("username").build();
    private static final CreateUserRequestModelMarshaller INSTANCE = new CreateUserRequestModelMarshaller();

    public static CreateUserRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateUserRequest createUserRequest, ProtocolMarshaller protocolMarshaller) {
        if (createUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createUserRequest.brokerId(), BROKERID_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.consoleAccess(), CONSOLEACCESS_BINDING);
            protocolMarshaller.marshall(createUserRequest.groups(), GROUPS_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

