/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.mq.model.ConfigurationRevision;
import software.amazon.awssdk.services.mq.model.ListOfSanitizationWarningCopier;
import software.amazon.awssdk.services.mq.model.MQResponse;
import software.amazon.awssdk.services.mq.model.SanitizationWarning;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateConfigurationResponse
extends MQResponse
implements ToCopyableBuilder<Builder, UpdateConfigurationResponse> {
    private final String arn;
    private final String id;
    private final ConfigurationRevision latestRevision;
    private final String name;
    private final List<SanitizationWarning> warnings;

    private UpdateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.warnings = builder.warnings;
    }

    public String arn() {
        return this.arn;
    }

    public String id() {
        return this.id;
    }

    public ConfigurationRevision latestRevision() {
        return this.latestRevision;
    }

    public String name() {
        return this.name;
    }

    public List<SanitizationWarning> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationResponse)) {
            return false;
        }
        UpdateConfigurationResponse other = (UpdateConfigurationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.latestRevision(), other.latestRevision()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.warnings(), other.warnings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateConfigurationResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("LatestRevision", (Object)this.latestRevision()).add("Name", (Object)this.name()).add("Warnings", this.warnings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "LatestRevision": {
                return Optional.of(clazz.cast(this.latestRevision()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Warnings": {
                return Optional.of(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MQResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private ConfigurationRevision latestRevision;
        private String name;
        private List<SanitizationWarning> warnings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationResponse model) {
            this.arn(model.arn);
            this.id(model.id);
            this.latestRevision(model.latestRevision);
            this.name(model.name);
            this.warnings(model.warnings);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return this.latestRevision != null ? this.latestRevision.toBuilder() : null;
        }

        @Override
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SanitizationWarning.Builder> getWarnings() {
            return this.warnings != null ? (Collection)this.warnings.stream().map(SanitizationWarning::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder warnings(Collection<SanitizationWarning> warnings) {
            this.warnings = ListOfSanitizationWarningCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(SanitizationWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<SanitizationWarning.BuilderImpl> warnings) {
            this.warnings = ListOfSanitizationWarningCopier.copyFromBuilder(warnings);
        }

        @Override
        public UpdateConfigurationResponse build() {
            return new UpdateConfigurationResponse(this);
        }
    }

    public static interface Builder
    extends MQResponse.Builder,
    CopyableBuilder<Builder, UpdateConfigurationResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder latestRevision(ConfigurationRevision var1);

        default public Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return this.latestRevision((ConfigurationRevision)((ConfigurationRevision.Builder)ConfigurationRevision.builder().apply(latestRevision)).build());
        }

        public Builder name(String var1);

        public Builder warnings(Collection<SanitizationWarning> var1);

        public Builder warnings(SanitizationWarning ... var1);
    }
}

