/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.model.ListOf__stringCopier;
import software.amazon.awssdk.services.mq.transform.BrokerInstanceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BrokerInstance
implements StructuredPojo,
ToCopyableBuilder<Builder, BrokerInstance> {
    private final String consoleURL;
    private final List<String> endpoints;

    private BrokerInstance(BuilderImpl builder) {
        this.consoleURL = builder.consoleURL;
        this.endpoints = builder.endpoints;
    }

    public String consoleURL() {
        return this.consoleURL;
    }

    public List<String> endpoints() {
        return this.endpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstance)) {
            return false;
        }
        BrokerInstance other = (BrokerInstance)obj;
        return Objects.equals(this.consoleURL(), other.consoleURL()) && Objects.equals(this.endpoints(), other.endpoints());
    }

    public String toString() {
        return ToString.builder((String)"BrokerInstance").add("ConsoleURL", (Object)this.consoleURL()).add("Endpoints", this.endpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsoleURL": {
                return Optional.of(clazz.cast(this.consoleURL()));
            }
            case "Endpoints": {
                return Optional.of(clazz.cast(this.endpoints()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BrokerInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String consoleURL;
        private List<String> endpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerInstance model) {
            this.consoleURL(model.consoleURL);
            this.endpoints(model.endpoints);
        }

        public final String getConsoleURL() {
            return this.consoleURL;
        }

        @Override
        public final Builder consoleURL(String consoleURL) {
            this.consoleURL = consoleURL;
            return this;
        }

        public final void setConsoleURL(String consoleURL) {
            this.consoleURL = consoleURL;
        }

        public final Collection<String> getEndpoints() {
            return this.endpoints;
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ListOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ListOf__stringCopier.copy(endpoints);
        }

        public BrokerInstance build() {
            return new BrokerInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BrokerInstance> {
        public Builder consoleURL(String var1);

        public Builder endpoints(Collection<String> var1);

        public Builder endpoints(String ... var1);
    }
}

