/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mq.model.WeeklyStartTime;

public class WeeklyStartTimeUnmarshaller
implements Unmarshaller<WeeklyStartTime, JsonUnmarshallerContext> {
    private static final WeeklyStartTimeUnmarshaller INSTANCE = new WeeklyStartTimeUnmarshaller();

    public WeeklyStartTime unmarshall(JsonUnmarshallerContext context) throws Exception {
        WeeklyStartTime.Builder weeklyStartTimeBuilder = WeeklyStartTime.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("dayOfWeek", targetDepth)) {
                    context.nextToken();
                    weeklyStartTimeBuilder.dayOfWeek((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("timeOfDay", targetDepth)) {
                    context.nextToken();
                    weeklyStartTimeBuilder.timeOfDay((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("timeZone", targetDepth)) {
                    context.nextToken();
                    weeklyStartTimeBuilder.timeZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (WeeklyStartTime)weeklyStartTimeBuilder.build();
    }

    public static WeeklyStartTimeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

