/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.UpdateUserRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateUserRequestModelMarshaller {
    private static final MarshallingInfo<String> BROKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("broker-id").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CONSOLEACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("consoleAccess").isBinary(false).build();
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groups").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("password").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("username").isBinary(false).build();
    private static final UpdateUserRequestModelMarshaller INSTANCE = new UpdateUserRequestModelMarshaller();

    private UpdateUserRequestModelMarshaller() {
    }

    public static UpdateUserRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateUserRequest updateUserRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateUserRequest), (String)"updateUserRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateUserRequest.brokerId(), BROKERID_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.consoleAccess(), CONSOLEACCESS_BINDING);
            protocolMarshaller.marshall(updateUserRequest.groups(), GROUPS_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)updateUserRequest.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

