/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.CreateConfigurationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateConfigurationRequestModelMarshaller {
    private static final MarshallingInfo<String> ENGINETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("engineType").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("engineVersion").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final CreateConfigurationRequestModelMarshaller INSTANCE = new CreateConfigurationRequestModelMarshaller();

    private CreateConfigurationRequestModelMarshaller() {
    }

    public static CreateConfigurationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateConfigurationRequest createConfigurationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createConfigurationRequest), (String)"createConfigurationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createConfigurationRequest.engineTypeAsString(), ENGINETYPE_BINDING);
            protocolMarshaller.marshall((Object)createConfigurationRequest.engineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)createConfigurationRequest.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

