/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.mq.model.CreateBrokerRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateBrokerRequestModelMarshaller {
    private static final MarshallingInfo<Boolean> AUTOMINORVERSIONUPGRADE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoMinorVersionUpgrade").isBinary(false).build();
    private static final MarshallingInfo<String> BROKERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").isBinary(false).build();
    private static final MarshallingInfo<String> CREATORREQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creatorRequestId").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> DEPLOYMENTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentMode").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("engineType").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("engineVersion").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostInstanceType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MAINTENANCEWINDOWSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maintenanceWindowStartTime").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PUBLICLYACCESSIBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publiclyAccessible").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroups").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnetIds").isBinary(false).build();
    private static final MarshallingInfo<List> USERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("users").isBinary(false).build();
    private static final CreateBrokerRequestModelMarshaller INSTANCE = new CreateBrokerRequestModelMarshaller();

    private CreateBrokerRequestModelMarshaller() {
    }

    public static CreateBrokerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateBrokerRequest createBrokerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createBrokerRequest), (String)"createBrokerRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createBrokerRequest.autoMinorVersionUpgrade(), AUTOMINORVERSIONUPGRADE_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.brokerName(), BROKERNAME_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.creatorRequestId(), CREATORREQUESTID_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.deploymentModeAsString(), DEPLOYMENTMODE_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.engineTypeAsString(), ENGINETYPE_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.engineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.hostInstanceType(), HOSTINSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.maintenanceWindowStartTime(), MAINTENANCEWINDOWSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)createBrokerRequest.publiclyAccessible(), PUBLICLYACCESSIBLE_BINDING);
            protocolMarshaller.marshall(createBrokerRequest.securityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall(createBrokerRequest.subnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(createBrokerRequest.users(), USERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

