/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.model.DayOfWeek;
import software.amazon.awssdk.services.mq.transform.WeeklyStartTimeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WeeklyStartTime
implements StructuredPojo,
ToCopyableBuilder<Builder, WeeklyStartTime> {
    private final String dayOfWeek;
    private final String timeOfDay;
    private final String timeZone;

    private WeeklyStartTime(BuilderImpl builder) {
        this.dayOfWeek = builder.dayOfWeek;
        this.timeOfDay = builder.timeOfDay;
        this.timeZone = builder.timeZone;
    }

    public DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(this.dayOfWeek);
    }

    public String dayOfWeekAsString() {
        return this.dayOfWeek;
    }

    public String timeOfDay() {
        return this.timeOfDay;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklyStartTime)) {
            return false;
        }
        WeeklyStartTime other = (WeeklyStartTime)obj;
        return Objects.equals(this.dayOfWeekAsString(), other.dayOfWeekAsString()) && Objects.equals(this.timeOfDay(), other.timeOfDay()) && Objects.equals(this.timeZone(), other.timeZone());
    }

    public String toString() {
        return ToString.builder((String)"WeeklyStartTime").add("DayOfWeek", (Object)this.dayOfWeekAsString()).add("TimeOfDay", (Object)this.timeOfDay()).add("TimeZone", (Object)this.timeZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DayOfWeek": {
                return Optional.of(clazz.cast(this.dayOfWeekAsString()));
            }
            case "TimeOfDay": {
                return Optional.of(clazz.cast(this.timeOfDay()));
            }
            case "TimeZone": {
                return Optional.of(clazz.cast(this.timeZone()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WeeklyStartTimeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String dayOfWeek;
        private String timeOfDay;
        private String timeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklyStartTime model) {
            this.dayOfWeek(model.dayOfWeek);
            this.timeOfDay(model.timeOfDay);
            this.timeZone(model.timeZone);
        }

        public final String getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek.toString());
            return this;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public final String getTimeOfDay() {
            return this.timeOfDay;
        }

        @Override
        public final Builder timeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
            return this;
        }

        public final void setTimeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public WeeklyStartTime build() {
            return new WeeklyStartTime(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WeeklyStartTime> {
        public Builder dayOfWeek(String var1);

        public Builder dayOfWeek(DayOfWeek var1);

        public Builder timeOfDay(String var1);

        public Builder timeZone(String var1);
    }
}

