/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.mq.model.ConfigurationRevision;
import software.amazon.awssdk.services.mq.model.ListOfConfigurationRevisionCopier;
import software.amazon.awssdk.services.mq.model.MQResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListConfigurationRevisionsResponse
extends MQResponse
implements ToCopyableBuilder<Builder, ListConfigurationRevisionsResponse> {
    private final String configurationId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<ConfigurationRevision> revisions;

    private ListConfigurationRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.revisions = builder.revisions;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ConfigurationRevision> revisions() {
        return this.revisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationRevisionsResponse)) {
            return false;
        }
        ListConfigurationRevisionsResponse other = (ListConfigurationRevisionsResponse)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.revisions(), other.revisions());
    }

    public String toString() {
        return ToString.builder((String)"ListConfigurationRevisionsResponse").add("ConfigurationId", (Object)this.configurationId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Revisions", this.revisions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationId": {
                return Optional.of(clazz.cast(this.configurationId()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "Revisions": {
                return Optional.of(clazz.cast(this.revisions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MQResponse.BuilderImpl
    implements Builder {
        private String configurationId;
        private Integer maxResults;
        private String nextToken;
        private List<ConfigurationRevision> revisions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationRevisionsResponse model) {
            super(model);
            this.configurationId(model.configurationId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.revisions(model.revisions);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ConfigurationRevision.Builder> getRevisions() {
            return this.revisions != null ? (Collection)this.revisions.stream().map(ConfigurationRevision::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<ConfigurationRevision> revisions) {
            this.revisions = ListOfConfigurationRevisionCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(ConfigurationRevision ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<ConfigurationRevision.Builder> ... revisions) {
            this.revisions(Stream.of(revisions).map(c -> (ConfigurationRevision)((ConfigurationRevision.Builder)ConfigurationRevision.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRevisions(Collection<ConfigurationRevision.BuilderImpl> revisions) {
            this.revisions = ListOfConfigurationRevisionCopier.copyFromBuilder(revisions);
        }

        @Override
        public ListConfigurationRevisionsResponse build() {
            return new ListConfigurationRevisionsResponse(this);
        }
    }

    public static interface Builder
    extends MQResponse.Builder,
    CopyableBuilder<Builder, ListConfigurationRevisionsResponse> {
        public Builder configurationId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder revisions(Collection<ConfigurationRevision> var1);

        public Builder revisions(ConfigurationRevision ... var1);

        public Builder revisions(Consumer<ConfigurationRevision.Builder> ... var1);
    }
}

