/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.IdentityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApprovalTeamResponseApprover
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetApprovalTeamResponseApprover> {
    private static final SdkField<String> APPROVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApproverId").getter(GetApprovalTeamResponseApprover.getter(GetApprovalTeamResponseApprover::approverId)).setter(GetApprovalTeamResponseApprover.setter(Builder::approverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproverId").build()}).build();
    private static final SdkField<Instant> RESPONSE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResponseTime").getter(GetApprovalTeamResponseApprover.getter(GetApprovalTeamResponseApprover::responseTime)).setter(GetApprovalTeamResponseApprover.setter(Builder::responseTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PRIMARY_IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryIdentityId").getter(GetApprovalTeamResponseApprover.getter(GetApprovalTeamResponseApprover::primaryIdentityId)).setter(GetApprovalTeamResponseApprover.setter(Builder::primaryIdentityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIdentityId").build()}).build();
    private static final SdkField<String> PRIMARY_IDENTITY_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryIdentitySourceArn").getter(GetApprovalTeamResponseApprover.getter(GetApprovalTeamResponseApprover::primaryIdentitySourceArn)).setter(GetApprovalTeamResponseApprover.setter(Builder::primaryIdentitySourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIdentitySourceArn").build()}).build();
    private static final SdkField<String> PRIMARY_IDENTITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryIdentityStatus").getter(GetApprovalTeamResponseApprover.getter(GetApprovalTeamResponseApprover::primaryIdentityStatusAsString)).setter(GetApprovalTeamResponseApprover.setter(Builder::primaryIdentityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIdentityStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVER_ID_FIELD, RESPONSE_TIME_FIELD, PRIMARY_IDENTITY_ID_FIELD, PRIMARY_IDENTITY_SOURCE_ARN_FIELD, PRIMARY_IDENTITY_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApprovalTeamResponseApprover.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String approverId;
    private final Instant responseTime;
    private final String primaryIdentityId;
    private final String primaryIdentitySourceArn;
    private final String primaryIdentityStatus;

    private GetApprovalTeamResponseApprover(BuilderImpl builder) {
        this.approverId = builder.approverId;
        this.responseTime = builder.responseTime;
        this.primaryIdentityId = builder.primaryIdentityId;
        this.primaryIdentitySourceArn = builder.primaryIdentitySourceArn;
        this.primaryIdentityStatus = builder.primaryIdentityStatus;
    }

    public final String approverId() {
        return this.approverId;
    }

    public final Instant responseTime() {
        return this.responseTime;
    }

    public final String primaryIdentityId() {
        return this.primaryIdentityId;
    }

    public final String primaryIdentitySourceArn() {
        return this.primaryIdentitySourceArn;
    }

    public final IdentityStatus primaryIdentityStatus() {
        return IdentityStatus.fromValue(this.primaryIdentityStatus);
    }

    public final String primaryIdentityStatusAsString() {
        return this.primaryIdentityStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryIdentityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryIdentitySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryIdentityStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApprovalTeamResponseApprover)) {
            return false;
        }
        GetApprovalTeamResponseApprover other = (GetApprovalTeamResponseApprover)obj;
        return Objects.equals(this.approverId(), other.approverId()) && Objects.equals(this.responseTime(), other.responseTime()) && Objects.equals(this.primaryIdentityId(), other.primaryIdentityId()) && Objects.equals(this.primaryIdentitySourceArn(), other.primaryIdentitySourceArn()) && Objects.equals(this.primaryIdentityStatusAsString(), other.primaryIdentityStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetApprovalTeamResponseApprover").add("ApproverId", (Object)this.approverId()).add("ResponseTime", (Object)this.responseTime()).add("PrimaryIdentityId", (Object)this.primaryIdentityId()).add("PrimaryIdentitySourceArn", (Object)this.primaryIdentitySourceArn()).add("PrimaryIdentityStatus", (Object)this.primaryIdentityStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproverId": {
                return Optional.ofNullable(clazz.cast(this.approverId()));
            }
            case "ResponseTime": {
                return Optional.ofNullable(clazz.cast(this.responseTime()));
            }
            case "PrimaryIdentityId": {
                return Optional.ofNullable(clazz.cast(this.primaryIdentityId()));
            }
            case "PrimaryIdentitySourceArn": {
                return Optional.ofNullable(clazz.cast(this.primaryIdentitySourceArn()));
            }
            case "PrimaryIdentityStatus": {
                return Optional.ofNullable(clazz.cast(this.primaryIdentityStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApproverId", APPROVER_ID_FIELD);
        map.put("ResponseTime", RESPONSE_TIME_FIELD);
        map.put("PrimaryIdentityId", PRIMARY_IDENTITY_ID_FIELD);
        map.put("PrimaryIdentitySourceArn", PRIMARY_IDENTITY_SOURCE_ARN_FIELD);
        map.put("PrimaryIdentityStatus", PRIMARY_IDENTITY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApprovalTeamResponseApprover, T> g) {
        return obj -> g.apply((GetApprovalTeamResponseApprover)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String approverId;
        private Instant responseTime;
        private String primaryIdentityId;
        private String primaryIdentitySourceArn;
        private String primaryIdentityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApprovalTeamResponseApprover model) {
            this.approverId(model.approverId);
            this.responseTime(model.responseTime);
            this.primaryIdentityId(model.primaryIdentityId);
            this.primaryIdentitySourceArn(model.primaryIdentitySourceArn);
            this.primaryIdentityStatus(model.primaryIdentityStatus);
        }

        public final String getApproverId() {
            return this.approverId;
        }

        public final void setApproverId(String approverId) {
            this.approverId = approverId;
        }

        @Override
        public final Builder approverId(String approverId) {
            this.approverId = approverId;
            return this;
        }

        public final Instant getResponseTime() {
            return this.responseTime;
        }

        public final void setResponseTime(Instant responseTime) {
            this.responseTime = responseTime;
        }

        @Override
        public final Builder responseTime(Instant responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public final String getPrimaryIdentityId() {
            return this.primaryIdentityId;
        }

        public final void setPrimaryIdentityId(String primaryIdentityId) {
            this.primaryIdentityId = primaryIdentityId;
        }

        @Override
        public final Builder primaryIdentityId(String primaryIdentityId) {
            this.primaryIdentityId = primaryIdentityId;
            return this;
        }

        public final String getPrimaryIdentitySourceArn() {
            return this.primaryIdentitySourceArn;
        }

        public final void setPrimaryIdentitySourceArn(String primaryIdentitySourceArn) {
            this.primaryIdentitySourceArn = primaryIdentitySourceArn;
        }

        @Override
        public final Builder primaryIdentitySourceArn(String primaryIdentitySourceArn) {
            this.primaryIdentitySourceArn = primaryIdentitySourceArn;
            return this;
        }

        public final String getPrimaryIdentityStatus() {
            return this.primaryIdentityStatus;
        }

        public final void setPrimaryIdentityStatus(String primaryIdentityStatus) {
            this.primaryIdentityStatus = primaryIdentityStatus;
        }

        @Override
        public final Builder primaryIdentityStatus(String primaryIdentityStatus) {
            this.primaryIdentityStatus = primaryIdentityStatus;
            return this;
        }

        @Override
        public final Builder primaryIdentityStatus(IdentityStatus primaryIdentityStatus) {
            this.primaryIdentityStatus(primaryIdentityStatus == null ? null : primaryIdentityStatus.toString());
            return this;
        }

        public GetApprovalTeamResponseApprover build() {
            return new GetApprovalTeamResponseApprover(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetApprovalTeamResponseApprover> {
        public Builder approverId(String var1);

        public Builder responseTime(Instant var1);

        public Builder primaryIdentityId(String var1);

        public Builder primaryIdentitySourceArn(String var1);

        public Builder primaryIdentityStatus(String var1);

        public Builder primaryIdentityStatus(IdentityStatus var1);
    }
}

