/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for an approval team
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApprovalTeamsResponseApprovalTeam implements SdkPojo, Serializable,
        ToCopyableBuilder<ListApprovalTeamsResponseApprovalTeam.Builder, ListApprovalTeamsResponseApprovalTeam> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(ListApprovalTeamsResponseApprovalTeam::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ApprovalStrategyResponse> APPROVAL_STRATEGY_FIELD = SdkField
            .<ApprovalStrategyResponse> builder(MarshallingType.SDK_POJO).memberName("ApprovalStrategy")
            .getter(getter(ListApprovalTeamsResponseApprovalTeam::approvalStrategy)).setter(setter(Builder::approvalStrategy))
            .constructor(ApprovalStrategyResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()).build();

    private static final SdkField<Integer> NUMBER_OF_APPROVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfApprovers").getter(getter(ListApprovalTeamsResponseApprovalTeam::numberOfApprovers))
            .setter(setter(Builder::numberOfApprovers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfApprovers").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListApprovalTeamsResponseApprovalTeam::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListApprovalTeamsResponseApprovalTeam::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListApprovalTeamsResponseApprovalTeam::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListApprovalTeamsResponseApprovalTeam::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(ListApprovalTeamsResponseApprovalTeam::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ListApprovalTeamsResponseApprovalTeam::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            APPROVAL_STRATEGY_FIELD, NUMBER_OF_APPROVERS_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD,
            STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final ApprovalStrategyResponse approvalStrategy;

    private final Integer numberOfApprovers;

    private final String arn;

    private final String name;

    private final String description;

    private final String status;

    private final String statusCode;

    private final String statusMessage;

    private ListApprovalTeamsResponseApprovalTeam(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.approvalStrategy = builder.approvalStrategy;
        this.numberOfApprovers = builder.numberOfApprovers;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * Timestamp when the team was created.
     * </p>
     * 
     * @return Timestamp when the team was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * An <code>ApprovalStrategyResponse</code> object. Contains details for how an approval team grants approval.
     * </p>
     * 
     * @return An <code>ApprovalStrategyResponse</code> object. Contains details for how an approval team grants
     *         approval.
     */
    public final ApprovalStrategyResponse approvalStrategy() {
        return approvalStrategy;
    }

    /**
     * <p>
     * Total number of approvers in the team.
     * </p>
     * 
     * @return Total number of approvers in the team.
     */
    public final Integer numberOfApprovers() {
        return numberOfApprovers;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the team.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the team.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Name of the team.
     * </p>
     * 
     * @return Name of the team.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description for the team.
     * </p>
     * 
     * @return Description for the team.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Status for the team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApprovalTeamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the team. For more information, see <a
     *         href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
     *         <i>Multi-party approval User Guide</i>.
     * @see ApprovalTeamStatus
     */
    public final ApprovalTeamStatus status() {
        return ApprovalTeamStatus.fromValue(status);
    }

    /**
     * <p>
     * Status for the team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApprovalTeamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the team. For more information, see <a
     *         href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
     *         <i>Multi-party approval User Guide</i>.
     * @see ApprovalTeamStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Status code for the team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ApprovalTeamStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code for the team. For more information, see <a
     *         href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
     *         <i>Multi-party approval User Guide</i>.
     * @see ApprovalTeamStatusCode
     */
    public final ApprovalTeamStatusCode statusCode() {
        return ApprovalTeamStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * Status code for the team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ApprovalTeamStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code for the team. For more information, see <a
     *         href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
     *         <i>Multi-party approval User Guide</i>.
     * @see ApprovalTeamStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * Message describing the status for the team.
     * </p>
     * 
     * @return Message describing the status for the team.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfApprovers());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApprovalTeamsResponseApprovalTeam)) {
            return false;
        }
        ListApprovalTeamsResponseApprovalTeam other = (ListApprovalTeamsResponseApprovalTeam) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(approvalStrategy(), other.approvalStrategy())
                && Objects.equals(numberOfApprovers(), other.numberOfApprovers()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApprovalTeamsResponseApprovalTeam").add("CreationTime", creationTime())
                .add("ApprovalStrategy", approvalStrategy()).add("NumberOfApprovers", numberOfApprovers()).add("Arn", arn())
                .add("Name", name()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("StatusCode", statusCodeAsString()).add("StatusMessage", statusMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ApprovalStrategy":
            return Optional.ofNullable(clazz.cast(approvalStrategy()));
        case "NumberOfApprovers":
            return Optional.ofNullable(clazz.cast(numberOfApprovers()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("NumberOfApprovers", NUMBER_OF_APPROVERS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApprovalTeamsResponseApprovalTeam, T> g) {
        return obj -> g.apply((ListApprovalTeamsResponseApprovalTeam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListApprovalTeamsResponseApprovalTeam> {
        /**
         * <p>
         * Timestamp when the team was created.
         * </p>
         * 
         * @param creationTime
         *        Timestamp when the team was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * An <code>ApprovalStrategyResponse</code> object. Contains details for how an approval team grants approval.
         * </p>
         * 
         * @param approvalStrategy
         *        An <code>ApprovalStrategyResponse</code> object. Contains details for how an approval team grants
         *        approval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy);

        /**
         * <p>
         * An <code>ApprovalStrategyResponse</code> object. Contains details for how an approval team grants approval.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApprovalStrategyResponse.Builder}
         * avoiding the need to create one manually via {@link ApprovalStrategyResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalStrategyResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #approvalStrategy(ApprovalStrategyResponse)}.
         * 
         * @param approvalStrategy
         *        a consumer that will call methods on {@link ApprovalStrategyResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalStrategy(ApprovalStrategyResponse)
         */
        default Builder approvalStrategy(Consumer<ApprovalStrategyResponse.Builder> approvalStrategy) {
            return approvalStrategy(ApprovalStrategyResponse.builder().applyMutation(approvalStrategy).build());
        }

        /**
         * <p>
         * Total number of approvers in the team.
         * </p>
         * 
         * @param numberOfApprovers
         *        Total number of approvers in the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfApprovers(Integer numberOfApprovers);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the team.
         * </p>
         * 
         * @param arn
         *        Amazon Resource Name (ARN) for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Name of the team.
         * </p>
         * 
         * @param name
         *        Name of the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description for the team.
         * </p>
         * 
         * @param description
         *        Description for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Status for the team. For more information, see <a
         * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
         * approval User Guide</i>.
         * </p>
         * 
         * @param status
         *        Status for the team. For more information, see <a
         *        href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
         *        <i>Multi-party approval User Guide</i>.
         * @see ApprovalTeamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalTeamStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status for the team. For more information, see <a
         * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
         * approval User Guide</i>.
         * </p>
         * 
         * @param status
         *        Status for the team. For more information, see <a
         *        href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
         *        <i>Multi-party approval User Guide</i>.
         * @see ApprovalTeamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalTeamStatus
         */
        Builder status(ApprovalTeamStatus status);

        /**
         * <p>
         * Status code for the team. For more information, see <a
         * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
         * approval User Guide</i>.
         * </p>
         * 
         * @param statusCode
         *        Status code for the team. For more information, see <a
         *        href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
         *        <i>Multi-party approval User Guide</i>.
         * @see ApprovalTeamStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalTeamStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * Status code for the team. For more information, see <a
         * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
         * approval User Guide</i>.
         * </p>
         * 
         * @param statusCode
         *        Status code for the team. For more information, see <a
         *        href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
         *        <i>Multi-party approval User Guide</i>.
         * @see ApprovalTeamStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalTeamStatusCode
         */
        Builder statusCode(ApprovalTeamStatusCode statusCode);

        /**
         * <p>
         * Message describing the status for the team.
         * </p>
         * 
         * @param statusMessage
         *        Message describing the status for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private ApprovalStrategyResponse approvalStrategy;

        private Integer numberOfApprovers;

        private String arn;

        private String name;

        private String description;

        private String status;

        private String statusCode;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApprovalTeamsResponseApprovalTeam model) {
            creationTime(model.creationTime);
            approvalStrategy(model.approvalStrategy);
            numberOfApprovers(model.numberOfApprovers);
            arn(model.arn);
            name(model.name);
            description(model.description);
            status(model.status);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ApprovalStrategyResponse.Builder getApprovalStrategy() {
            return approvalStrategy != null ? approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategyResponse.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final Integer getNumberOfApprovers() {
            return numberOfApprovers;
        }

        public final void setNumberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
        }

        @Override
        public final Builder numberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApprovalTeamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ApprovalTeamStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ListApprovalTeamsResponseApprovalTeam build() {
            return new ListApprovalTeamsResponseApprovalTeam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
