/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for the version of a policy. Policies define what operations a team that define the permissions for
 * team resources.
 * </p>
 * <p>
 * The protected operation for a service integration might require specific permissions. For more information, see <a
 * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
 * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyVersionSummary.Builder, PolicyVersionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PolicyVersionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(PolicyVersionSummary::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<Integer> VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VersionId").getter(getter(PolicyVersionSummary::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(PolicyVersionSummary::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(PolicyVersionSummary::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PolicyVersionSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PolicyVersionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(PolicyVersionSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime")
            .getter(getter(PolicyVersionSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, POLICY_ARN_FIELD,
            VERSION_ID_FIELD, POLICY_TYPE_FIELD, IS_DEFAULT_FIELD, NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String policyArn;

    private final Integer versionId;

    private final String policyType;

    private final Boolean isDefault;

    private final String name;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private PolicyVersionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.policyArn = builder.policyArn;
        this.versionId = builder.versionId;
        this.policyType = builder.policyType;
        this.isDefault = builder.isDefault;
        this.name = builder.name;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the team.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the team.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the policy.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * Version ID for the policy.
     * </p>
     * 
     * @return Version ID for the policy.
     */
    public final Integer versionId() {
        return versionId;
    }

    /**
     * <p>
     * The type of policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy.
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy.
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * Determines if the specified policy is the default for the team.
     * </p>
     * 
     * @return Determines if the specified policy is the default for the team.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * Name of the policy
     * </p>
     * 
     * @return Name of the policy
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Status for the policy. For example, if the policy is <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html">attachable</a> or <a
     * href="https://docs.aws.amazon.com/access_policies_managed-deprecated.html">deprecated</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the policy. For example, if the policy is <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html"
     *         >attachable</a> or <a
     *         href="https://docs.aws.amazon.com/access_policies_managed-deprecated.html">deprecated</a>.
     * @see PolicyStatus
     */
    public final PolicyStatus status() {
        return PolicyStatus.fromValue(status);
    }

    /**
     * <p>
     * Status for the policy. For example, if the policy is <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html">attachable</a> or <a
     * href="https://docs.aws.amazon.com/access_policies_managed-deprecated.html">deprecated</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the policy. For example, if the policy is <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html"
     *         >attachable</a> or <a
     *         href="https://docs.aws.amazon.com/access_policies_managed-deprecated.html">deprecated</a>.
     * @see PolicyStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Timestamp when the policy was created.
     * </p>
     * 
     * @return Timestamp when the policy was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Timestamp when the policy was last updated.
     * </p>
     * 
     * @return Timestamp when the policy was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersionSummary)) {
            return false;
        }
        PolicyVersionSummary other = (PolicyVersionSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(versionId(), other.versionId())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(isDefault(), other.isDefault()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyVersionSummary").add("Arn", arn()).add("PolicyArn", policyArn())
                .add("VersionId", versionId()).add("PolicyType", policyTypeAsString()).add("IsDefault", isDefault())
                .add("Name", name()).add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("PolicyArn", POLICY_ARN_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyVersionSummary, T> g) {
        return obj -> g.apply((PolicyVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyVersionSummary> {
        /**
         * <p>
         * Amazon Resource Name (ARN) for the team.
         * </p>
         * 
         * @param arn
         *        Amazon Resource Name (ARN) for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the policy.
         * </p>
         * 
         * @param policyArn
         *        Amazon Resource Name (ARN) for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * Version ID for the policy.
         * </p>
         * 
         * @param versionId
         *        Version ID for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(Integer versionId);

        /**
         * <p>
         * The type of policy.
         * </p>
         * 
         * @param policyType
         *        The type of policy.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy.
         * </p>
         * 
         * @param policyType
         *        The type of policy.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * Determines if the specified policy is the default for the team.
         * </p>
         * 
         * @param isDefault
         *        Determines if the specified policy is the default for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * Name of the policy
         * </p>
         * 
         * @param name
         *        Name of the policy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Status for the policy. For example, if the policy is <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html">attachable</a> or
         * <a href="https://docs.aws.amazon.com/access_policies_managed-deprecated.html">deprecated</a>.
         * </p>
         * 
         * @param status
         *        Status for the policy. For example, if the policy is <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html"
         *        >attachable</a> or <a
         *        href="https://docs.aws.amazon.com/access_policies_managed-deprecated.html">deprecated</a>.
         * @see PolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status for the policy. For example, if the policy is <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html">attachable</a> or
         * <a href="https://docs.aws.amazon.com/access_policies_managed-deprecated.html">deprecated</a>.
         * </p>
         * 
         * @param status
         *        Status for the policy. For example, if the policy is <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_attach-policy.html"
         *        >attachable</a> or <a
         *        href="https://docs.aws.amazon.com/access_policies_managed-deprecated.html">deprecated</a>.
         * @see PolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyStatus
         */
        Builder status(PolicyStatus status);

        /**
         * <p>
         * Timestamp when the policy was created.
         * </p>
         * 
         * @param creationTime
         *        Timestamp when the policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Timestamp when the policy was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Timestamp when the policy was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String policyArn;

        private Integer versionId;

        private String policyType;

        private Boolean isDefault;

        private String name;

        private String status;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersionSummary model) {
            arn(model.arn);
            policyArn(model.policyArn);
            versionId(model.versionId);
            policyType(model.policyType);
            isDefault(model.isDefault);
            name(model.name);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Integer getVersionId() {
            return versionId;
        }

        public final void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(Integer versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PolicyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public PolicyVersionSummary build() {
            return new PolicyVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
