/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionResponse extends MpaResponse implements
        ToCopyableBuilder<GetSessionResponse.Builder, GetSessionResponse> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionArn").getter(getter(GetSessionResponse::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionArn").build()).build();

    private static final SdkField<String> APPROVAL_TEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalTeamArn").getter(getter(GetSessionResponse::approvalTeamArn))
            .setter(setter(Builder::approvalTeamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeamArn").build()).build();

    private static final SdkField<String> APPROVAL_TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalTeamName").getter(getter(GetSessionResponse::approvalTeamName))
            .setter(setter(Builder::approvalTeamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeamName").build()).build();

    private static final SdkField<String> PROTECTED_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectedResourceArn").getter(getter(GetSessionResponse::protectedResourceArn))
            .setter(setter(Builder::protectedResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceArn").build())
            .build();

    private static final SdkField<ApprovalStrategyResponse> APPROVAL_STRATEGY_FIELD = SdkField
            .<ApprovalStrategyResponse> builder(MarshallingType.SDK_POJO).memberName("ApprovalStrategy")
            .getter(getter(GetSessionResponse::approvalStrategy)).setter(setter(Builder::approvalStrategy))
            .constructor(ApprovalStrategyResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()).build();

    private static final SdkField<Integer> NUMBER_OF_APPROVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfApprovers").getter(getter(GetSessionResponse::numberOfApprovers))
            .setter(setter(Builder::numberOfApprovers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfApprovers").build()).build();

    private static final SdkField<Instant> INITIATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InitiationTime")
            .getter(getter(GetSessionResponse::initiationTime))
            .setter(setter(Builder::initiationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTime")
            .getter(getter(GetSessionResponse::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime")
            .getter(getter(GetSessionResponse::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetSessionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Metadata")
            .getter(getter(GetSessionResponse::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetSessionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(GetSessionResponse::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetSessionResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionStatus").getter(getter(GetSessionResponse::executionStatusAsString))
            .setter(setter(Builder::executionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(GetSessionResponse::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()).build();

    private static final SdkField<String> REQUESTER_SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterServicePrincipal").getter(getter(GetSessionResponse::requesterServicePrincipal))
            .setter(setter(Builder::requesterServicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterServicePrincipal").build())
            .build();

    private static final SdkField<String> REQUESTER_PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterPrincipalArn").getter(getter(GetSessionResponse::requesterPrincipalArn))
            .setter(setter(Builder::requesterPrincipalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPrincipalArn").build())
            .build();

    private static final SdkField<String> REQUESTER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterAccountId").getter(getter(GetSessionResponse::requesterAccountId))
            .setter(setter(Builder::requesterAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAccountId").build())
            .build();

    private static final SdkField<String> REQUESTER_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterRegion").getter(getter(GetSessionResponse::requesterRegion))
            .setter(setter(Builder::requesterRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterRegion").build()).build();

    private static final SdkField<String> REQUESTER_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterComment").getter(getter(GetSessionResponse::requesterComment))
            .setter(setter(Builder::requesterComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterComment").build()).build();

    private static final SdkField<String> ACTION_COMPLETION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionCompletionStrategy").getter(getter(GetSessionResponse::actionCompletionStrategyAsString))
            .setter(setter(Builder::actionCompletionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionCompletionStrategy").build())
            .build();

    private static final SdkField<List<GetSessionResponseApproverResponse>> APPROVER_RESPONSES_FIELD = SdkField
            .<List<GetSessionResponseApproverResponse>> builder(MarshallingType.LIST)
            .memberName("ApproverResponses")
            .getter(getter(GetSessionResponse::approverResponses))
            .setter(setter(Builder::approverResponses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproverResponses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetSessionResponseApproverResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetSessionResponseApproverResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD,
            APPROVAL_TEAM_ARN_FIELD, APPROVAL_TEAM_NAME_FIELD, PROTECTED_RESOURCE_ARN_FIELD, APPROVAL_STRATEGY_FIELD,
            NUMBER_OF_APPROVERS_FIELD, INITIATION_TIME_FIELD, EXPIRATION_TIME_FIELD, COMPLETION_TIME_FIELD, DESCRIPTION_FIELD,
            METADATA_FIELD, STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, EXECUTION_STATUS_FIELD, ACTION_NAME_FIELD,
            REQUESTER_SERVICE_PRINCIPAL_FIELD, REQUESTER_PRINCIPAL_ARN_FIELD, REQUESTER_ACCOUNT_ID_FIELD, REQUESTER_REGION_FIELD,
            REQUESTER_COMMENT_FIELD, ACTION_COMPLETION_STRATEGY_FIELD, APPROVER_RESPONSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionArn;

    private final String approvalTeamArn;

    private final String approvalTeamName;

    private final String protectedResourceArn;

    private final ApprovalStrategyResponse approvalStrategy;

    private final Integer numberOfApprovers;

    private final Instant initiationTime;

    private final Instant expirationTime;

    private final Instant completionTime;

    private final String description;

    private final Map<String, String> metadata;

    private final String status;

    private final String statusCode;

    private final String statusMessage;

    private final String executionStatus;

    private final String actionName;

    private final String requesterServicePrincipal;

    private final String requesterPrincipalArn;

    private final String requesterAccountId;

    private final String requesterRegion;

    private final String requesterComment;

    private final String actionCompletionStrategy;

    private final List<GetSessionResponseApproverResponse> approverResponses;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionArn = builder.sessionArn;
        this.approvalTeamArn = builder.approvalTeamArn;
        this.approvalTeamName = builder.approvalTeamName;
        this.protectedResourceArn = builder.protectedResourceArn;
        this.approvalStrategy = builder.approvalStrategy;
        this.numberOfApprovers = builder.numberOfApprovers;
        this.initiationTime = builder.initiationTime;
        this.expirationTime = builder.expirationTime;
        this.completionTime = builder.completionTime;
        this.description = builder.description;
        this.metadata = builder.metadata;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.executionStatus = builder.executionStatus;
        this.actionName = builder.actionName;
        this.requesterServicePrincipal = builder.requesterServicePrincipal;
        this.requesterPrincipalArn = builder.requesterPrincipalArn;
        this.requesterAccountId = builder.requesterAccountId;
        this.requesterRegion = builder.requesterRegion;
        this.requesterComment = builder.requesterComment;
        this.actionCompletionStrategy = builder.actionCompletionStrategy;
        this.approverResponses = builder.approverResponses;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the session.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the approval team.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the approval team.
     */
    public final String approvalTeamArn() {
        return approvalTeamArn;
    }

    /**
     * <p>
     * Name of the approval team.
     * </p>
     * 
     * @return Name of the approval team.
     */
    public final String approvalTeamName() {
        return approvalTeamName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the protected operation.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the protected operation.
     */
    public final String protectedResourceArn() {
        return protectedResourceArn;
    }

    /**
     * <p>
     * An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval
     * </p>
     * 
     * @return An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval
     */
    public final ApprovalStrategyResponse approvalStrategy() {
        return approvalStrategy;
    }

    /**
     * <p>
     * Total number of approvers in the session.
     * </p>
     * 
     * @return Total number of approvers in the session.
     */
    public final Integer numberOfApprovers() {
        return numberOfApprovers;
    }

    /**
     * <p>
     * Timestamp when the session was initiated.
     * </p>
     * 
     * @return Timestamp when the session was initiated.
     */
    public final Instant initiationTime() {
        return initiationTime;
    }

    /**
     * <p>
     * Timestamp when the session will expire.
     * </p>
     * 
     * @return Timestamp when the session will expire.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * Timestamp when the session completed.
     * </p>
     * 
     * @return Timestamp when the session completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * Description for the session.
     * </p>
     * 
     * @return Description for the session.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata for the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return Metadata for the session.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * Status for the session. For example, if the team has approved the requested operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the session. For example, if the team has approved the requested operation.
     * @see SessionStatus
     */
    public final SessionStatus status() {
        return SessionStatus.fromValue(status);
    }

    /**
     * <p>
     * Status for the session. For example, if the team has approved the requested operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the session. For example, if the team has approved the requested operation.
     * @see SessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Status code of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link SessionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of the session.
     * @see SessionStatusCode
     */
    public final SessionStatusCode statusCode() {
        return SessionStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * Status code of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link SessionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of the session.
     * @see SessionStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * Message describing the status for session.
     * </p>
     * 
     * @return Message describing the status for session.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Status for the protected operation. For example, if the operation is <code>PENDING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link SessionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return Status for the protected operation. For example, if the operation is <code>PENDING</code>.
     * @see SessionExecutionStatus
     */
    public final SessionExecutionStatus executionStatus() {
        return SessionExecutionStatus.fromValue(executionStatus);
    }

    /**
     * <p>
     * Status for the protected operation. For example, if the operation is <code>PENDING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link SessionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return Status for the protected operation. For example, if the operation is <code>PENDING</code>.
     * @see SessionExecutionStatus
     */
    public final String executionStatusAsString() {
        return executionStatus;
    }

    /**
     * <p>
     * Name of the protected operation.
     * </p>
     * 
     * @return Name of the protected operation.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services"
     * >Service principal</a> for the service associated with the protected operation.
     * </p>
     * 
     * @return <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services"
     *         >Service principal</a> for the service associated with the protected operation.
     */
    public final String requesterServicePrincipal() {
        return requesterServicePrincipal;
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request">IAM
     * principal</a> that made the operation request.
     * </p>
     * 
     * @return <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request">IAM
     *         principal</a> that made the operation request.
     */
    public final String requesterPrincipalArn() {
        return requesterPrincipalArn;
    }

    /**
     * <p>
     * ID for the account that made the operation request.
     * </p>
     * 
     * @return ID for the account that made the operation request.
     */
    public final String requesterAccountId() {
        return requesterAccountId;
    }

    /**
     * <p>
     * Amazon Web Services Region where the operation request originated.
     * </p>
     * 
     * @return Amazon Web Services Region where the operation request originated.
     */
    public final String requesterRegion() {
        return requesterRegion;
    }

    /**
     * <p>
     * Message from the account that made the operation request
     * </p>
     * 
     * @return Message from the account that made the operation request
     */
    public final String requesterComment() {
        return requesterComment;
    }

    /**
     * <p>
     * Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the operation is
     * automatically executed using the requester's permissions, if approved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionCompletionStrategy} will return {@link ActionCompletionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #actionCompletionStrategyAsString}.
     * </p>
     * 
     * @return Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
     *         operation is automatically executed using the requester's permissions, if approved.
     * @see ActionCompletionStrategy
     */
    public final ActionCompletionStrategy actionCompletionStrategy() {
        return ActionCompletionStrategy.fromValue(actionCompletionStrategy);
    }

    /**
     * <p>
     * Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the operation is
     * automatically executed using the requester's permissions, if approved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionCompletionStrategy} will return {@link ActionCompletionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #actionCompletionStrategyAsString}.
     * </p>
     * 
     * @return Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
     *         operation is automatically executed using the requester's permissions, if approved.
     * @see ActionCompletionStrategy
     */
    public final String actionCompletionStrategyAsString() {
        return actionCompletionStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApproverResponses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApproverResponses() {
        return approverResponses != null && !(approverResponses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>GetSessionResponseApproverResponse</code> objects. Contains details for approver responses in
     * the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApproverResponses} method.
     * </p>
     * 
     * @return An array of <code>GetSessionResponseApproverResponse</code> objects. Contains details for approver
     *         responses in the session.
     */
    public final List<GetSessionResponseApproverResponse> approverResponses() {
        return approverResponses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(approvalTeamArn());
        hashCode = 31 * hashCode + Objects.hashCode(approvalTeamName());
        hashCode = 31 * hashCode + Objects.hashCode(protectedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfApprovers());
        hashCode = 31 * hashCode + Objects.hashCode(initiationTime());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(requesterServicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterRegion());
        hashCode = 31 * hashCode + Objects.hashCode(requesterComment());
        hashCode = 31 * hashCode + Objects.hashCode(actionCompletionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasApproverResponses() ? approverResponses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse) obj;
        return Objects.equals(sessionArn(), other.sessionArn()) && Objects.equals(approvalTeamArn(), other.approvalTeamArn())
                && Objects.equals(approvalTeamName(), other.approvalTeamName())
                && Objects.equals(protectedResourceArn(), other.protectedResourceArn())
                && Objects.equals(approvalStrategy(), other.approvalStrategy())
                && Objects.equals(numberOfApprovers(), other.numberOfApprovers())
                && Objects.equals(initiationTime(), other.initiationTime())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(completionTime(), other.completionTime()) && Objects.equals(description(), other.description())
                && hasMetadata() == other.hasMetadata() && Objects.equals(metadata(), other.metadata())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(executionStatusAsString(), other.executionStatusAsString())
                && Objects.equals(actionName(), other.actionName())
                && Objects.equals(requesterServicePrincipal(), other.requesterServicePrincipal())
                && Objects.equals(requesterPrincipalArn(), other.requesterPrincipalArn())
                && Objects.equals(requesterAccountId(), other.requesterAccountId())
                && Objects.equals(requesterRegion(), other.requesterRegion())
                && Objects.equals(requesterComment(), other.requesterComment())
                && Objects.equals(actionCompletionStrategyAsString(), other.actionCompletionStrategyAsString())
                && hasApproverResponses() == other.hasApproverResponses()
                && Objects.equals(approverResponses(), other.approverResponses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSessionResponse").add("SessionArn", sessionArn()).add("ApprovalTeamArn", approvalTeamArn())
                .add("ApprovalTeamName", approvalTeamName()).add("ProtectedResourceArn", protectedResourceArn())
                .add("ApprovalStrategy", approvalStrategy()).add("NumberOfApprovers", numberOfApprovers())
                .add("InitiationTime", initiationTime()).add("ExpirationTime", expirationTime())
                .add("CompletionTime", completionTime())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("StatusCode", statusCodeAsString()).add("StatusMessage", statusMessage())
                .add("ExecutionStatus", executionStatusAsString()).add("ActionName", actionName())
                .add("RequesterServicePrincipal", requesterServicePrincipal())
                .add("RequesterPrincipalArn", requesterPrincipalArn()).add("RequesterAccountId", requesterAccountId())
                .add("RequesterRegion", requesterRegion())
                .add("RequesterComment", requesterComment() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ActionCompletionStrategy", actionCompletionStrategyAsString())
                .add("ApproverResponses", hasApproverResponses() ? approverResponses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "ApprovalTeamArn":
            return Optional.ofNullable(clazz.cast(approvalTeamArn()));
        case "ApprovalTeamName":
            return Optional.ofNullable(clazz.cast(approvalTeamName()));
        case "ProtectedResourceArn":
            return Optional.ofNullable(clazz.cast(protectedResourceArn()));
        case "ApprovalStrategy":
            return Optional.ofNullable(clazz.cast(approvalStrategy()));
        case "NumberOfApprovers":
            return Optional.ofNullable(clazz.cast(numberOfApprovers()));
        case "InitiationTime":
            return Optional.ofNullable(clazz.cast(initiationTime()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ExecutionStatus":
            return Optional.ofNullable(clazz.cast(executionStatusAsString()));
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "RequesterServicePrincipal":
            return Optional.ofNullable(clazz.cast(requesterServicePrincipal()));
        case "RequesterPrincipalArn":
            return Optional.ofNullable(clazz.cast(requesterPrincipalArn()));
        case "RequesterAccountId":
            return Optional.ofNullable(clazz.cast(requesterAccountId()));
        case "RequesterRegion":
            return Optional.ofNullable(clazz.cast(requesterRegion()));
        case "RequesterComment":
            return Optional.ofNullable(clazz.cast(requesterComment()));
        case "ActionCompletionStrategy":
            return Optional.ofNullable(clazz.cast(actionCompletionStrategyAsString()));
        case "ApproverResponses":
            return Optional.ofNullable(clazz.cast(approverResponses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionArn", SESSION_ARN_FIELD);
        map.put("ApprovalTeamArn", APPROVAL_TEAM_ARN_FIELD);
        map.put("ApprovalTeamName", APPROVAL_TEAM_NAME_FIELD);
        map.put("ProtectedResourceArn", PROTECTED_RESOURCE_ARN_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("NumberOfApprovers", NUMBER_OF_APPROVERS_FIELD);
        map.put("InitiationTime", INITIATION_TIME_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ExecutionStatus", EXECUTION_STATUS_FIELD);
        map.put("ActionName", ACTION_NAME_FIELD);
        map.put("RequesterServicePrincipal", REQUESTER_SERVICE_PRINCIPAL_FIELD);
        map.put("RequesterPrincipalArn", REQUESTER_PRINCIPAL_ARN_FIELD);
        map.put("RequesterAccountId", REQUESTER_ACCOUNT_ID_FIELD);
        map.put("RequesterRegion", REQUESTER_REGION_FIELD);
        map.put("RequesterComment", REQUESTER_COMMENT_FIELD);
        map.put("ActionCompletionStrategy", ACTION_COMPLETION_STRATEGY_FIELD);
        map.put("ApproverResponses", APPROVER_RESPONSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSessionResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) for the session.
         * </p>
         * 
         * @param sessionArn
         *        Amazon Resource Name (ARN) for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the approval team.
         * </p>
         * 
         * @param approvalTeamArn
         *        Amazon Resource Name (ARN) for the approval team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalTeamArn(String approvalTeamArn);

        /**
         * <p>
         * Name of the approval team.
         * </p>
         * 
         * @param approvalTeamName
         *        Name of the approval team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalTeamName(String approvalTeamName);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the protected operation.
         * </p>
         * 
         * @param protectedResourceArn
         *        Amazon Resource Name (ARN) for the protected operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceArn(String protectedResourceArn);

        /**
         * <p>
         * An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval
         * </p>
         * 
         * @param approvalStrategy
         *        An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy);

        /**
         * <p>
         * An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval
         * </p>
         * This is a convenience method that creates an instance of the {@link ApprovalStrategyResponse.Builder}
         * avoiding the need to create one manually via {@link ApprovalStrategyResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalStrategyResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #approvalStrategy(ApprovalStrategyResponse)}.
         * 
         * @param approvalStrategy
         *        a consumer that will call methods on {@link ApprovalStrategyResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalStrategy(ApprovalStrategyResponse)
         */
        default Builder approvalStrategy(Consumer<ApprovalStrategyResponse.Builder> approvalStrategy) {
            return approvalStrategy(ApprovalStrategyResponse.builder().applyMutation(approvalStrategy).build());
        }

        /**
         * <p>
         * Total number of approvers in the session.
         * </p>
         * 
         * @param numberOfApprovers
         *        Total number of approvers in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfApprovers(Integer numberOfApprovers);

        /**
         * <p>
         * Timestamp when the session was initiated.
         * </p>
         * 
         * @param initiationTime
         *        Timestamp when the session was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationTime(Instant initiationTime);

        /**
         * <p>
         * Timestamp when the session will expire.
         * </p>
         * 
         * @param expirationTime
         *        Timestamp when the session will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * Timestamp when the session completed.
         * </p>
         * 
         * @param completionTime
         *        Timestamp when the session completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * Description for the session.
         * </p>
         * 
         * @param description
         *        Description for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Metadata for the session.
         * </p>
         * 
         * @param metadata
         *        Metadata for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * Status for the session. For example, if the team has approved the requested operation.
         * </p>
         * 
         * @param status
         *        Status for the session. For example, if the team has approved the requested operation.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status for the session. For example, if the team has approved the requested operation.
         * </p>
         * 
         * @param status
         *        Status for the session. For example, if the team has approved the requested operation.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * Status code of the session.
         * </p>
         * 
         * @param statusCode
         *        Status code of the session.
         * @see SessionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * Status code of the session.
         * </p>
         * 
         * @param statusCode
         *        Status code of the session.
         * @see SessionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatusCode
         */
        Builder statusCode(SessionStatusCode statusCode);

        /**
         * <p>
         * Message describing the status for session.
         * </p>
         * 
         * @param statusMessage
         *        Message describing the status for session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Status for the protected operation. For example, if the operation is <code>PENDING</code>.
         * </p>
         * 
         * @param executionStatus
         *        Status for the protected operation. For example, if the operation is <code>PENDING</code>.
         * @see SessionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionExecutionStatus
         */
        Builder executionStatus(String executionStatus);

        /**
         * <p>
         * Status for the protected operation. For example, if the operation is <code>PENDING</code>.
         * </p>
         * 
         * @param executionStatus
         *        Status for the protected operation. For example, if the operation is <code>PENDING</code>.
         * @see SessionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionExecutionStatus
         */
        Builder executionStatus(SessionExecutionStatus executionStatus);

        /**
         * <p>
         * Name of the protected operation.
         * </p>
         * 
         * @param actionName
         *        Name of the protected operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services"
         * >Service principal</a> for the service associated with the protected operation.
         * </p>
         * 
         * @param requesterServicePrincipal
         *        <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services"
         *        >Service principal</a> for the service associated with the protected operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterServicePrincipal(String requesterServicePrincipal);

        /**
         * <p>
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request">IAM
         * principal</a> that made the operation request.
         * </p>
         * 
         * @param requesterPrincipalArn
         *        <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request"
         *        >IAM principal</a> that made the operation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPrincipalArn(String requesterPrincipalArn);

        /**
         * <p>
         * ID for the account that made the operation request.
         * </p>
         * 
         * @param requesterAccountId
         *        ID for the account that made the operation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAccountId(String requesterAccountId);

        /**
         * <p>
         * Amazon Web Services Region where the operation request originated.
         * </p>
         * 
         * @param requesterRegion
         *        Amazon Web Services Region where the operation request originated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterRegion(String requesterRegion);

        /**
         * <p>
         * Message from the account that made the operation request
         * </p>
         * 
         * @param requesterComment
         *        Message from the account that made the operation request
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterComment(String requesterComment);

        /**
         * <p>
         * Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
         * operation is automatically executed using the requester's permissions, if approved.
         * </p>
         * 
         * @param actionCompletionStrategy
         *        Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
         *        operation is automatically executed using the requester's permissions, if approved.
         * @see ActionCompletionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCompletionStrategy
         */
        Builder actionCompletionStrategy(String actionCompletionStrategy);

        /**
         * <p>
         * Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
         * operation is automatically executed using the requester's permissions, if approved.
         * </p>
         * 
         * @param actionCompletionStrategy
         *        Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
         *        operation is automatically executed using the requester's permissions, if approved.
         * @see ActionCompletionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCompletionStrategy
         */
        Builder actionCompletionStrategy(ActionCompletionStrategy actionCompletionStrategy);

        /**
         * <p>
         * An array of <code>GetSessionResponseApproverResponse</code> objects. Contains details for approver responses
         * in the session.
         * </p>
         * 
         * @param approverResponses
         *        An array of <code>GetSessionResponseApproverResponse</code> objects. Contains details for approver
         *        responses in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approverResponses(Collection<GetSessionResponseApproverResponse> approverResponses);

        /**
         * <p>
         * An array of <code>GetSessionResponseApproverResponse</code> objects. Contains details for approver responses
         * in the session.
         * </p>
         * 
         * @param approverResponses
         *        An array of <code>GetSessionResponseApproverResponse</code> objects. Contains details for approver
         *        responses in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approverResponses(GetSessionResponseApproverResponse... approverResponses);

        /**
         * <p>
         * An array of <code>GetSessionResponseApproverResponse</code> objects. Contains details for approver responses
         * in the session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mpa.model.GetSessionResponseApproverResponse.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mpa.model.GetSessionResponseApproverResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mpa.model.GetSessionResponseApproverResponse.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #approverResponses(List<GetSessionResponseApproverResponse>)}.
         * 
         * @param approverResponses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mpa.model.GetSessionResponseApproverResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approverResponses(java.util.Collection<GetSessionResponseApproverResponse>)
         */
        Builder approverResponses(Consumer<GetSessionResponseApproverResponse.Builder>... approverResponses);
    }

    static final class BuilderImpl extends MpaResponse.BuilderImpl implements Builder {
        private String sessionArn;

        private String approvalTeamArn;

        private String approvalTeamName;

        private String protectedResourceArn;

        private ApprovalStrategyResponse approvalStrategy;

        private Integer numberOfApprovers;

        private Instant initiationTime;

        private Instant expirationTime;

        private Instant completionTime;

        private String description;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private String statusCode;

        private String statusMessage;

        private String executionStatus;

        private String actionName;

        private String requesterServicePrincipal;

        private String requesterPrincipalArn;

        private String requesterAccountId;

        private String requesterRegion;

        private String requesterComment;

        private String actionCompletionStrategy;

        private List<GetSessionResponseApproverResponse> approverResponses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            sessionArn(model.sessionArn);
            approvalTeamArn(model.approvalTeamArn);
            approvalTeamName(model.approvalTeamName);
            protectedResourceArn(model.protectedResourceArn);
            approvalStrategy(model.approvalStrategy);
            numberOfApprovers(model.numberOfApprovers);
            initiationTime(model.initiationTime);
            expirationTime(model.expirationTime);
            completionTime(model.completionTime);
            description(model.description);
            metadata(model.metadata);
            status(model.status);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
            executionStatus(model.executionStatus);
            actionName(model.actionName);
            requesterServicePrincipal(model.requesterServicePrincipal);
            requesterPrincipalArn(model.requesterPrincipalArn);
            requesterAccountId(model.requesterAccountId);
            requesterRegion(model.requesterRegion);
            requesterComment(model.requesterComment);
            actionCompletionStrategy(model.actionCompletionStrategy);
            approverResponses(model.approverResponses);
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getApprovalTeamArn() {
            return approvalTeamArn;
        }

        public final void setApprovalTeamArn(String approvalTeamArn) {
            this.approvalTeamArn = approvalTeamArn;
        }

        @Override
        public final Builder approvalTeamArn(String approvalTeamArn) {
            this.approvalTeamArn = approvalTeamArn;
            return this;
        }

        public final String getApprovalTeamName() {
            return approvalTeamName;
        }

        public final void setApprovalTeamName(String approvalTeamName) {
            this.approvalTeamName = approvalTeamName;
        }

        @Override
        public final Builder approvalTeamName(String approvalTeamName) {
            this.approvalTeamName = approvalTeamName;
            return this;
        }

        public final String getProtectedResourceArn() {
            return protectedResourceArn;
        }

        public final void setProtectedResourceArn(String protectedResourceArn) {
            this.protectedResourceArn = protectedResourceArn;
        }

        @Override
        public final Builder protectedResourceArn(String protectedResourceArn) {
            this.protectedResourceArn = protectedResourceArn;
            return this;
        }

        public final ApprovalStrategyResponse.Builder getApprovalStrategy() {
            return approvalStrategy != null ? approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategyResponse.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final Integer getNumberOfApprovers() {
            return numberOfApprovers;
        }

        public final void setNumberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
        }

        @Override
        public final Builder numberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
            return this;
        }

        public final Instant getInitiationTime() {
            return initiationTime;
        }

        public final void setInitiationTime(Instant initiationTime) {
            this.initiationTime = initiationTime;
        }

        @Override
        public final Builder initiationTime(Instant initiationTime) {
            this.initiationTime = initiationTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = SessionMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = SessionMetadataCopier.copy(metadata);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(SessionStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getExecutionStatus() {
            return executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(SessionExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getRequesterServicePrincipal() {
            return requesterServicePrincipal;
        }

        public final void setRequesterServicePrincipal(String requesterServicePrincipal) {
            this.requesterServicePrincipal = requesterServicePrincipal;
        }

        @Override
        public final Builder requesterServicePrincipal(String requesterServicePrincipal) {
            this.requesterServicePrincipal = requesterServicePrincipal;
            return this;
        }

        public final String getRequesterPrincipalArn() {
            return requesterPrincipalArn;
        }

        public final void setRequesterPrincipalArn(String requesterPrincipalArn) {
            this.requesterPrincipalArn = requesterPrincipalArn;
        }

        @Override
        public final Builder requesterPrincipalArn(String requesterPrincipalArn) {
            this.requesterPrincipalArn = requesterPrincipalArn;
            return this;
        }

        public final String getRequesterAccountId() {
            return requesterAccountId;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final String getRequesterRegion() {
            return requesterRegion;
        }

        public final void setRequesterRegion(String requesterRegion) {
            this.requesterRegion = requesterRegion;
        }

        @Override
        public final Builder requesterRegion(String requesterRegion) {
            this.requesterRegion = requesterRegion;
            return this;
        }

        public final String getRequesterComment() {
            return requesterComment;
        }

        public final void setRequesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
        }

        @Override
        public final Builder requesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
            return this;
        }

        public final String getActionCompletionStrategy() {
            return actionCompletionStrategy;
        }

        public final void setActionCompletionStrategy(String actionCompletionStrategy) {
            this.actionCompletionStrategy = actionCompletionStrategy;
        }

        @Override
        public final Builder actionCompletionStrategy(String actionCompletionStrategy) {
            this.actionCompletionStrategy = actionCompletionStrategy;
            return this;
        }

        @Override
        public final Builder actionCompletionStrategy(ActionCompletionStrategy actionCompletionStrategy) {
            this.actionCompletionStrategy(actionCompletionStrategy == null ? null : actionCompletionStrategy.toString());
            return this;
        }

        public final List<GetSessionResponseApproverResponse.Builder> getApproverResponses() {
            List<GetSessionResponseApproverResponse.Builder> result = GetSessionResponseApproverResponsesCopier
                    .copyToBuilder(this.approverResponses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApproverResponses(Collection<GetSessionResponseApproverResponse.BuilderImpl> approverResponses) {
            this.approverResponses = GetSessionResponseApproverResponsesCopier.copyFromBuilder(approverResponses);
        }

        @Override
        public final Builder approverResponses(Collection<GetSessionResponseApproverResponse> approverResponses) {
            this.approverResponses = GetSessionResponseApproverResponsesCopier.copy(approverResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approverResponses(GetSessionResponseApproverResponse... approverResponses) {
            approverResponses(Arrays.asList(approverResponses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approverResponses(Consumer<GetSessionResponseApproverResponse.Builder>... approverResponses) {
            approverResponses(Stream.of(approverResponses)
                    .map(c -> GetSessionResponseApproverResponse.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
