/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for an approver.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApprovalTeamResponseApprover implements SdkPojo, Serializable,
        ToCopyableBuilder<GetApprovalTeamResponseApprover.Builder, GetApprovalTeamResponseApprover> {
    private static final SdkField<String> APPROVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApproverId").getter(getter(GetApprovalTeamResponseApprover::approverId))
            .setter(setter(Builder::approverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproverId").build()).build();

    private static final SdkField<Instant> RESPONSE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ResponseTime")
            .getter(getter(GetApprovalTeamResponseApprover::responseTime))
            .setter(setter(Builder::responseTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PRIMARY_IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryIdentityId").getter(getter(GetApprovalTeamResponseApprover::primaryIdentityId))
            .setter(setter(Builder::primaryIdentityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIdentityId").build()).build();

    private static final SdkField<String> PRIMARY_IDENTITY_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryIdentitySourceArn").getter(getter(GetApprovalTeamResponseApprover::primaryIdentitySourceArn))
            .setter(setter(Builder::primaryIdentitySourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIdentitySourceArn").build())
            .build();

    private static final SdkField<String> PRIMARY_IDENTITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryIdentityStatus").getter(getter(GetApprovalTeamResponseApprover::primaryIdentityStatusAsString))
            .setter(setter(Builder::primaryIdentityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIdentityStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVER_ID_FIELD,
            RESPONSE_TIME_FIELD, PRIMARY_IDENTITY_ID_FIELD, PRIMARY_IDENTITY_SOURCE_ARN_FIELD, PRIMARY_IDENTITY_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String approverId;

    private final Instant responseTime;

    private final String primaryIdentityId;

    private final String primaryIdentitySourceArn;

    private final String primaryIdentityStatus;

    private GetApprovalTeamResponseApprover(BuilderImpl builder) {
        this.approverId = builder.approverId;
        this.responseTime = builder.responseTime;
        this.primaryIdentityId = builder.primaryIdentityId;
        this.primaryIdentitySourceArn = builder.primaryIdentitySourceArn;
        this.primaryIdentityStatus = builder.primaryIdentityStatus;
    }

    /**
     * <p>
     * ID for the approver.
     * </p>
     * 
     * @return ID for the approver.
     */
    public final String approverId() {
        return approverId;
    }

    /**
     * <p>
     * Timestamp when the approver responded to an approval team invitation.
     * </p>
     * 
     * @return Timestamp when the approver responded to an approval team invitation.
     */
    public final Instant responseTime() {
        return responseTime;
    }

    /**
     * <p>
     * ID for the user.
     * </p>
     * 
     * @return ID for the user.
     */
    public final String primaryIdentityId() {
        return primaryIdentityId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication for
     * approvers.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication
     *         for approvers.
     */
    public final String primaryIdentitySourceArn() {
        return primaryIdentitySourceArn;
    }

    /**
     * <p>
     * Status for the identity source. For example, if an approver has accepted a team invitation with a user
     * authentication method managed by the identity source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #primaryIdentityStatus} will return {@link IdentityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #primaryIdentityStatusAsString}.
     * </p>
     * 
     * @return Status for the identity source. For example, if an approver has accepted a team invitation with a user
     *         authentication method managed by the identity source.
     * @see IdentityStatus
     */
    public final IdentityStatus primaryIdentityStatus() {
        return IdentityStatus.fromValue(primaryIdentityStatus);
    }

    /**
     * <p>
     * Status for the identity source. For example, if an approver has accepted a team invitation with a user
     * authentication method managed by the identity source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #primaryIdentityStatus} will return {@link IdentityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #primaryIdentityStatusAsString}.
     * </p>
     * 
     * @return Status for the identity source. For example, if an approver has accepted a team invitation with a user
     *         authentication method managed by the identity source.
     * @see IdentityStatus
     */
    public final String primaryIdentityStatusAsString() {
        return primaryIdentityStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approverId());
        hashCode = 31 * hashCode + Objects.hashCode(responseTime());
        hashCode = 31 * hashCode + Objects.hashCode(primaryIdentityId());
        hashCode = 31 * hashCode + Objects.hashCode(primaryIdentitySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(primaryIdentityStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApprovalTeamResponseApprover)) {
            return false;
        }
        GetApprovalTeamResponseApprover other = (GetApprovalTeamResponseApprover) obj;
        return Objects.equals(approverId(), other.approverId()) && Objects.equals(responseTime(), other.responseTime())
                && Objects.equals(primaryIdentityId(), other.primaryIdentityId())
                && Objects.equals(primaryIdentitySourceArn(), other.primaryIdentitySourceArn())
                && Objects.equals(primaryIdentityStatusAsString(), other.primaryIdentityStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApprovalTeamResponseApprover").add("ApproverId", approverId())
                .add("ResponseTime", responseTime()).add("PrimaryIdentityId", primaryIdentityId())
                .add("PrimaryIdentitySourceArn", primaryIdentitySourceArn())
                .add("PrimaryIdentityStatus", primaryIdentityStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApproverId":
            return Optional.ofNullable(clazz.cast(approverId()));
        case "ResponseTime":
            return Optional.ofNullable(clazz.cast(responseTime()));
        case "PrimaryIdentityId":
            return Optional.ofNullable(clazz.cast(primaryIdentityId()));
        case "PrimaryIdentitySourceArn":
            return Optional.ofNullable(clazz.cast(primaryIdentitySourceArn()));
        case "PrimaryIdentityStatus":
            return Optional.ofNullable(clazz.cast(primaryIdentityStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApproverId", APPROVER_ID_FIELD);
        map.put("ResponseTime", RESPONSE_TIME_FIELD);
        map.put("PrimaryIdentityId", PRIMARY_IDENTITY_ID_FIELD);
        map.put("PrimaryIdentitySourceArn", PRIMARY_IDENTITY_SOURCE_ARN_FIELD);
        map.put("PrimaryIdentityStatus", PRIMARY_IDENTITY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApprovalTeamResponseApprover, T> g) {
        return obj -> g.apply((GetApprovalTeamResponseApprover) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetApprovalTeamResponseApprover> {
        /**
         * <p>
         * ID for the approver.
         * </p>
         * 
         * @param approverId
         *        ID for the approver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approverId(String approverId);

        /**
         * <p>
         * Timestamp when the approver responded to an approval team invitation.
         * </p>
         * 
         * @param responseTime
         *        Timestamp when the approver responded to an approval team invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTime(Instant responseTime);

        /**
         * <p>
         * ID for the user.
         * </p>
         * 
         * @param primaryIdentityId
         *        ID for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryIdentityId(String primaryIdentityId);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the identity source. The identity source manages the user authentication for
         * approvers.
         * </p>
         * 
         * @param primaryIdentitySourceArn
         *        Amazon Resource Name (ARN) for the identity source. The identity source manages the user
         *        authentication for approvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryIdentitySourceArn(String primaryIdentitySourceArn);

        /**
         * <p>
         * Status for the identity source. For example, if an approver has accepted a team invitation with a user
         * authentication method managed by the identity source.
         * </p>
         * 
         * @param primaryIdentityStatus
         *        Status for the identity source. For example, if an approver has accepted a team invitation with a user
         *        authentication method managed by the identity source.
         * @see IdentityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityStatus
         */
        Builder primaryIdentityStatus(String primaryIdentityStatus);

        /**
         * <p>
         * Status for the identity source. For example, if an approver has accepted a team invitation with a user
         * authentication method managed by the identity source.
         * </p>
         * 
         * @param primaryIdentityStatus
         *        Status for the identity source. For example, if an approver has accepted a team invitation with a user
         *        authentication method managed by the identity source.
         * @see IdentityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityStatus
         */
        Builder primaryIdentityStatus(IdentityStatus primaryIdentityStatus);
    }

    static final class BuilderImpl implements Builder {
        private String approverId;

        private Instant responseTime;

        private String primaryIdentityId;

        private String primaryIdentitySourceArn;

        private String primaryIdentityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApprovalTeamResponseApprover model) {
            approverId(model.approverId);
            responseTime(model.responseTime);
            primaryIdentityId(model.primaryIdentityId);
            primaryIdentitySourceArn(model.primaryIdentitySourceArn);
            primaryIdentityStatus(model.primaryIdentityStatus);
        }

        public final String getApproverId() {
            return approverId;
        }

        public final void setApproverId(String approverId) {
            this.approverId = approverId;
        }

        @Override
        public final Builder approverId(String approverId) {
            this.approverId = approverId;
            return this;
        }

        public final Instant getResponseTime() {
            return responseTime;
        }

        public final void setResponseTime(Instant responseTime) {
            this.responseTime = responseTime;
        }

        @Override
        public final Builder responseTime(Instant responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public final String getPrimaryIdentityId() {
            return primaryIdentityId;
        }

        public final void setPrimaryIdentityId(String primaryIdentityId) {
            this.primaryIdentityId = primaryIdentityId;
        }

        @Override
        public final Builder primaryIdentityId(String primaryIdentityId) {
            this.primaryIdentityId = primaryIdentityId;
            return this;
        }

        public final String getPrimaryIdentitySourceArn() {
            return primaryIdentitySourceArn;
        }

        public final void setPrimaryIdentitySourceArn(String primaryIdentitySourceArn) {
            this.primaryIdentitySourceArn = primaryIdentitySourceArn;
        }

        @Override
        public final Builder primaryIdentitySourceArn(String primaryIdentitySourceArn) {
            this.primaryIdentitySourceArn = primaryIdentitySourceArn;
            return this;
        }

        public final String getPrimaryIdentityStatus() {
            return primaryIdentityStatus;
        }

        public final void setPrimaryIdentityStatus(String primaryIdentityStatus) {
            this.primaryIdentityStatus = primaryIdentityStatus;
        }

        @Override
        public final Builder primaryIdentityStatus(String primaryIdentityStatus) {
            this.primaryIdentityStatus = primaryIdentityStatus;
            return this;
        }

        @Override
        public final Builder primaryIdentityStatus(IdentityStatus primaryIdentityStatus) {
            this.primaryIdentityStatus(primaryIdentityStatus == null ? null : primaryIdentityStatus.toString());
            return this;
        }

        @Override
        public GetApprovalTeamResponseApprover build() {
            return new GetApprovalTeamResponseApprover(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
