/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApprovalTeamResponse extends MpaResponse implements
        ToCopyableBuilder<GetApprovalTeamResponse.Builder, GetApprovalTeamResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(GetApprovalTeamResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ApprovalStrategyResponse> APPROVAL_STRATEGY_FIELD = SdkField
            .<ApprovalStrategyResponse> builder(MarshallingType.SDK_POJO).memberName("ApprovalStrategy")
            .getter(getter(GetApprovalTeamResponse::approvalStrategy)).setter(setter(Builder::approvalStrategy))
            .constructor(ApprovalStrategyResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()).build();

    private static final SdkField<Integer> NUMBER_OF_APPROVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfApprovers").getter(getter(GetApprovalTeamResponse::numberOfApprovers))
            .setter(setter(Builder::numberOfApprovers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfApprovers").build()).build();

    private static final SdkField<List<GetApprovalTeamResponseApprover>> APPROVERS_FIELD = SdkField
            .<List<GetApprovalTeamResponseApprover>> builder(MarshallingType.LIST)
            .memberName("Approvers")
            .getter(getter(GetApprovalTeamResponse::approvers))
            .setter(setter(Builder::approvers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Approvers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetApprovalTeamResponseApprover> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetApprovalTeamResponseApprover::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetApprovalTeamResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetApprovalTeamResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetApprovalTeamResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetApprovalTeamResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(GetApprovalTeamResponse::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetApprovalTeamResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> UPDATE_SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateSessionArn").getter(getter(GetApprovalTeamResponse::updateSessionArn))
            .setter(setter(Builder::updateSessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateSessionArn").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(GetApprovalTeamResponse::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<List<PolicyReference>> POLICIES_FIELD = SdkField
            .<List<PolicyReference>> builder(MarshallingType.LIST)
            .memberName("Policies")
            .getter(getter(GetApprovalTeamResponse::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime")
            .getter(getter(GetApprovalTeamResponse::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<PendingUpdate> PENDING_UPDATE_FIELD = SdkField
            .<PendingUpdate> builder(MarshallingType.SDK_POJO).memberName("PendingUpdate")
            .getter(getter(GetApprovalTeamResponse::pendingUpdate)).setter(setter(Builder::pendingUpdate))
            .constructor(PendingUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            APPROVAL_STRATEGY_FIELD, NUMBER_OF_APPROVERS_FIELD, APPROVERS_FIELD, ARN_FIELD, DESCRIPTION_FIELD, NAME_FIELD,
            STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, UPDATE_SESSION_ARN_FIELD, VERSION_ID_FIELD, POLICIES_FIELD,
            LAST_UPDATE_TIME_FIELD, PENDING_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant creationTime;

    private final ApprovalStrategyResponse approvalStrategy;

    private final Integer numberOfApprovers;

    private final List<GetApprovalTeamResponseApprover> approvers;

    private final String arn;

    private final String description;

    private final String name;

    private final String status;

    private final String statusCode;

    private final String statusMessage;

    private final String updateSessionArn;

    private final String versionId;

    private final List<PolicyReference> policies;

    private final Instant lastUpdateTime;

    private final PendingUpdate pendingUpdate;

    private GetApprovalTeamResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.approvalStrategy = builder.approvalStrategy;
        this.numberOfApprovers = builder.numberOfApprovers;
        this.approvers = builder.approvers;
        this.arn = builder.arn;
        this.description = builder.description;
        this.name = builder.name;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.updateSessionArn = builder.updateSessionArn;
        this.versionId = builder.versionId;
        this.policies = builder.policies;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.pendingUpdate = builder.pendingUpdate;
    }

    /**
     * <p>
     * Timestamp when the team was created.
     * </p>
     * 
     * @return Timestamp when the team was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval.
     * </p>
     * 
     * @return An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval.
     */
    public final ApprovalStrategyResponse approvalStrategy() {
        return approvalStrategy;
    }

    /**
     * <p>
     * Total number of approvers in the team.
     * </p>
     * 
     * @return Total number of approvers in the team.
     */
    public final Integer numberOfApprovers() {
        return numberOfApprovers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Approvers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasApprovers() {
        return approvers != null && !(approvers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>GetApprovalTeamResponseApprover </code> objects. Contains details for the approvers in the
     * team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApprovers} method.
     * </p>
     * 
     * @return An array of <code>GetApprovalTeamResponseApprover </code> objects. Contains details for the approvers in
     *         the team.
     */
    public final List<GetApprovalTeamResponseApprover> approvers() {
        return approvers;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the team.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the team.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Description for the team.
     * </p>
     * 
     * @return Description for the team.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Name of the approval team.
     * </p>
     * 
     * @return Name of the approval team.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Status for the team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApprovalTeamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the team. For more information, see <a
     *         href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
     *         <i>Multi-party approval User Guide</i>.
     * @see ApprovalTeamStatus
     */
    public final ApprovalTeamStatus status() {
        return ApprovalTeamStatus.fromValue(status);
    }

    /**
     * <p>
     * Status for the team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApprovalTeamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the team. For more information, see <a
     *         href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
     *         <i>Multi-party approval User Guide</i>.
     * @see ApprovalTeamStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Status code for the approval team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ApprovalTeamStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code for the approval team. For more information, see <a
     *         href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
     *         <i>Multi-party approval User Guide</i>.
     * @see ApprovalTeamStatusCode
     */
    public final ApprovalTeamStatusCode statusCode() {
        return ApprovalTeamStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * Status code for the approval team. For more information, see <a
     * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
     * approval User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ApprovalTeamStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code for the approval team. For more information, see <a
     *         href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
     *         <i>Multi-party approval User Guide</i>.
     * @see ApprovalTeamStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * Message describing the status for the team.
     * </p>
     * 
     * @return Message describing the status for the team.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the session.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the session.
     */
    public final String updateSessionArn() {
        return updateSessionArn;
    }

    /**
     * <p>
     * Version ID for the team.
     * </p>
     * 
     * @return Version ID for the team.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions for
     * team resources.
     * </p>
     * <p>
     * The protected operation for a service integration might require specific permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work with
     * Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions
     *         for team resources.</p>
     *         <p>
     *         The protected operation for a service integration might require specific permissions. For more
     *         information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
     *         other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
     */
    public final List<PolicyReference> policies() {
        return policies;
    }

    /**
     * <p>
     * Timestamp when the team was last updated.
     * </p>
     * 
     * @return Timestamp when the team was last updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * A <code>PendingUpdate</code> object. Contains details for the pending updates for the team, if applicable.
     * </p>
     * 
     * @return A <code>PendingUpdate</code> object. Contains details for the pending updates for the team, if
     *         applicable.
     */
    public final PendingUpdate pendingUpdate() {
        return pendingUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfApprovers());
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovers() ? approvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(updateSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(pendingUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApprovalTeamResponse)) {
            return false;
        }
        GetApprovalTeamResponse other = (GetApprovalTeamResponse) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(approvalStrategy(), other.approvalStrategy())
                && Objects.equals(numberOfApprovers(), other.numberOfApprovers()) && hasApprovers() == other.hasApprovers()
                && Objects.equals(approvers(), other.approvers()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(updateSessionArn(), other.updateSessionArn()) && Objects.equals(versionId(), other.versionId())
                && hasPolicies() == other.hasPolicies() && Objects.equals(policies(), other.policies())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(pendingUpdate(), other.pendingUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApprovalTeamResponse").add("CreationTime", creationTime())
                .add("ApprovalStrategy", approvalStrategy()).add("NumberOfApprovers", numberOfApprovers())
                .add("Approvers", hasApprovers() ? approvers() : null).add("Arn", arn())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Name", name())
                .add("Status", statusAsString()).add("StatusCode", statusCodeAsString()).add("StatusMessage", statusMessage())
                .add("UpdateSessionArn", updateSessionArn()).add("VersionId", versionId())
                .add("Policies", hasPolicies() ? policies() : null).add("LastUpdateTime", lastUpdateTime())
                .add("PendingUpdate", pendingUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ApprovalStrategy":
            return Optional.ofNullable(clazz.cast(approvalStrategy()));
        case "NumberOfApprovers":
            return Optional.ofNullable(clazz.cast(numberOfApprovers()));
        case "Approvers":
            return Optional.ofNullable(clazz.cast(approvers()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "UpdateSessionArn":
            return Optional.ofNullable(clazz.cast(updateSessionArn()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "PendingUpdate":
            return Optional.ofNullable(clazz.cast(pendingUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("NumberOfApprovers", NUMBER_OF_APPROVERS_FIELD);
        map.put("Approvers", APPROVERS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("UpdateSessionArn", UPDATE_SESSION_ARN_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("Policies", POLICIES_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("PendingUpdate", PENDING_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApprovalTeamResponse, T> g) {
        return obj -> g.apply((GetApprovalTeamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApprovalTeamResponse> {
        /**
         * <p>
         * Timestamp when the team was created.
         * </p>
         * 
         * @param creationTime
         *        Timestamp when the team was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval.
         * </p>
         * 
         * @param approvalStrategy
         *        An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy);

        /**
         * <p>
         * An <code>ApprovalStrategyResponse</code> object. Contains details for how the team grants approval.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApprovalStrategyResponse.Builder}
         * avoiding the need to create one manually via {@link ApprovalStrategyResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalStrategyResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #approvalStrategy(ApprovalStrategyResponse)}.
         * 
         * @param approvalStrategy
         *        a consumer that will call methods on {@link ApprovalStrategyResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalStrategy(ApprovalStrategyResponse)
         */
        default Builder approvalStrategy(Consumer<ApprovalStrategyResponse.Builder> approvalStrategy) {
            return approvalStrategy(ApprovalStrategyResponse.builder().applyMutation(approvalStrategy).build());
        }

        /**
         * <p>
         * Total number of approvers in the team.
         * </p>
         * 
         * @param numberOfApprovers
         *        Total number of approvers in the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfApprovers(Integer numberOfApprovers);

        /**
         * <p>
         * An array of <code>GetApprovalTeamResponseApprover </code> objects. Contains details for the approvers in the
         * team.
         * </p>
         * 
         * @param approvers
         *        An array of <code>GetApprovalTeamResponseApprover </code> objects. Contains details for the approvers
         *        in the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvers(Collection<GetApprovalTeamResponseApprover> approvers);

        /**
         * <p>
         * An array of <code>GetApprovalTeamResponseApprover </code> objects. Contains details for the approvers in the
         * team.
         * </p>
         * 
         * @param approvers
         *        An array of <code>GetApprovalTeamResponseApprover </code> objects. Contains details for the approvers
         *        in the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvers(GetApprovalTeamResponseApprover... approvers);

        /**
         * <p>
         * An array of <code>GetApprovalTeamResponseApprover </code> objects. Contains details for the approvers in the
         * team.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponseApprover.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponseApprover#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponseApprover.Builder#build()} is called
         * immediately and its result is passed to {@link #approvers(List<GetApprovalTeamResponseApprover>)}.
         * 
         * @param approvers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponseApprover.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvers(java.util.Collection<GetApprovalTeamResponseApprover>)
         */
        Builder approvers(Consumer<GetApprovalTeamResponseApprover.Builder>... approvers);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the team.
         * </p>
         * 
         * @param arn
         *        Amazon Resource Name (ARN) for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Description for the team.
         * </p>
         * 
         * @param description
         *        Description for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Name of the approval team.
         * </p>
         * 
         * @param name
         *        Name of the approval team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Status for the team. For more information, see <a
         * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
         * approval User Guide</i>.
         * </p>
         * 
         * @param status
         *        Status for the team. For more information, see <a
         *        href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
         *        <i>Multi-party approval User Guide</i>.
         * @see ApprovalTeamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalTeamStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status for the team. For more information, see <a
         * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
         * approval User Guide</i>.
         * </p>
         * 
         * @param status
         *        Status for the team. For more information, see <a
         *        href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
         *        <i>Multi-party approval User Guide</i>.
         * @see ApprovalTeamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalTeamStatus
         */
        Builder status(ApprovalTeamStatus status);

        /**
         * <p>
         * Status code for the approval team. For more information, see <a
         * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
         * approval User Guide</i>.
         * </p>
         * 
         * @param statusCode
         *        Status code for the approval team. For more information, see <a
         *        href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
         *        <i>Multi-party approval User Guide</i>.
         * @see ApprovalTeamStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalTeamStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * Status code for the approval team. For more information, see <a
         * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the <i>Multi-party
         * approval User Guide</i>.
         * </p>
         * 
         * @param statusCode
         *        Status code for the approval team. For more information, see <a
         *        href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Team health</a> in the
         *        <i>Multi-party approval User Guide</i>.
         * @see ApprovalTeamStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalTeamStatusCode
         */
        Builder statusCode(ApprovalTeamStatusCode statusCode);

        /**
         * <p>
         * Message describing the status for the team.
         * </p>
         * 
         * @param statusMessage
         *        Message describing the status for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the session.
         * </p>
         * 
         * @param updateSessionArn
         *        Amazon Resource Name (ARN) for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateSessionArn(String updateSessionArn);

        /**
         * <p>
         * Version ID for the team.
         * </p>
         * 
         * @param versionId
         *        Version ID for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions for
         * team resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * 
         * @param policies
         *        An array of <code>PolicyReference</code> objects. Contains a list of policies that define the
         *        permissions for team resources.</p>
         *        <p>
         *        The protected operation for a service integration might require specific permissions. For more
         *        information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
         *        other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<PolicyReference> policies);

        /**
         * <p>
         * An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions for
         * team resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * 
         * @param policies
         *        An array of <code>PolicyReference</code> objects. Contains a list of policies that define the
         *        permissions for team resources.</p>
         *        <p>
         *        The protected operation for a service integration might require specific permissions. For more
         *        information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How
         *        other services work with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(PolicyReference... policies);

        /**
         * <p>
         * An array of <code>PolicyReference</code> objects. Contains a list of policies that define the permissions for
         * team resources.
         * </p>
         * <p>
         * The protected operation for a service integration might require specific permissions. For more information,
         * see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-integrations.html">How other services work
         * with Multi-party approval</a> in the <i>Multi-party approval User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mpa.model.PolicyReference.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mpa.model.PolicyReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mpa.model.PolicyReference.Builder#build()} is called immediately and
         * its result is passed to {@link #policies(List<PolicyReference>)}.
         * 
         * @param policies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mpa.model.PolicyReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(java.util.Collection<PolicyReference>)
         */
        Builder policies(Consumer<PolicyReference.Builder>... policies);

        /**
         * <p>
         * Timestamp when the team was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        Timestamp when the team was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * A <code>PendingUpdate</code> object. Contains details for the pending updates for the team, if applicable.
         * </p>
         * 
         * @param pendingUpdate
         *        A <code>PendingUpdate</code> object. Contains details for the pending updates for the team, if
         *        applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingUpdate(PendingUpdate pendingUpdate);

        /**
         * <p>
         * A <code>PendingUpdate</code> object. Contains details for the pending updates for the team, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link PendingUpdate.Builder} avoiding the need
         * to create one manually via {@link PendingUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PendingUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #pendingUpdate(PendingUpdate)}.
         * 
         * @param pendingUpdate
         *        a consumer that will call methods on {@link PendingUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingUpdate(PendingUpdate)
         */
        default Builder pendingUpdate(Consumer<PendingUpdate.Builder> pendingUpdate) {
            return pendingUpdate(PendingUpdate.builder().applyMutation(pendingUpdate).build());
        }
    }

    static final class BuilderImpl extends MpaResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private ApprovalStrategyResponse approvalStrategy;

        private Integer numberOfApprovers;

        private List<GetApprovalTeamResponseApprover> approvers = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private String description;

        private String name;

        private String status;

        private String statusCode;

        private String statusMessage;

        private String updateSessionArn;

        private String versionId;

        private List<PolicyReference> policies = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdateTime;

        private PendingUpdate pendingUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApprovalTeamResponse model) {
            super(model);
            creationTime(model.creationTime);
            approvalStrategy(model.approvalStrategy);
            numberOfApprovers(model.numberOfApprovers);
            approvers(model.approvers);
            arn(model.arn);
            description(model.description);
            name(model.name);
            status(model.status);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
            updateSessionArn(model.updateSessionArn);
            versionId(model.versionId);
            policies(model.policies);
            lastUpdateTime(model.lastUpdateTime);
            pendingUpdate(model.pendingUpdate);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ApprovalStrategyResponse.Builder getApprovalStrategy() {
            return approvalStrategy != null ? approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategyResponse.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final Integer getNumberOfApprovers() {
            return numberOfApprovers;
        }

        public final void setNumberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
        }

        @Override
        public final Builder numberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
            return this;
        }

        public final List<GetApprovalTeamResponseApprover.Builder> getApprovers() {
            List<GetApprovalTeamResponseApprover.Builder> result = GetApprovalTeamResponseApproversCopier
                    .copyToBuilder(this.approvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovers(Collection<GetApprovalTeamResponseApprover.BuilderImpl> approvers) {
            this.approvers = GetApprovalTeamResponseApproversCopier.copyFromBuilder(approvers);
        }

        @Override
        public final Builder approvers(Collection<GetApprovalTeamResponseApprover> approvers) {
            this.approvers = GetApprovalTeamResponseApproversCopier.copy(approvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(GetApprovalTeamResponseApprover... approvers) {
            approvers(Arrays.asList(approvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(Consumer<GetApprovalTeamResponseApprover.Builder>... approvers) {
            approvers(Stream.of(approvers).map(c -> GetApprovalTeamResponseApprover.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApprovalTeamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ApprovalTeamStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getUpdateSessionArn() {
            return updateSessionArn;
        }

        public final void setUpdateSessionArn(String updateSessionArn) {
            this.updateSessionArn = updateSessionArn;
        }

        @Override
        public final Builder updateSessionArn(String updateSessionArn) {
            this.updateSessionArn = updateSessionArn;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final List<PolicyReference.Builder> getPolicies() {
            List<PolicyReference.Builder> result = PoliciesReferencesCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<PolicyReference.BuilderImpl> policies) {
            this.policies = PoliciesReferencesCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<PolicyReference> policies) {
            this.policies = PoliciesReferencesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyReference... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<PolicyReference.Builder>... policies) {
            policies(Stream.of(policies).map(c -> PolicyReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final PendingUpdate.Builder getPendingUpdate() {
            return pendingUpdate != null ? pendingUpdate.toBuilder() : null;
        }

        public final void setPendingUpdate(PendingUpdate.BuilderImpl pendingUpdate) {
            this.pendingUpdate = pendingUpdate != null ? pendingUpdate.build() : null;
        }

        @Override
        public final Builder pendingUpdate(PendingUpdate pendingUpdate) {
            this.pendingUpdate = pendingUpdate;
            return this;
        }

        @Override
        public GetApprovalTeamResponse build() {
            return new GetApprovalTeamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
