/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIdentitySourceResponse extends MpaResponse implements
        ToCopyableBuilder<CreateIdentitySourceResponse.Builder, CreateIdentitySourceResponse> {
    private static final SdkField<String> IDENTITY_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentitySourceType").getter(getter(CreateIdentitySourceResponse::identitySourceTypeAsString))
            .setter(setter(Builder::identitySourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceType").build())
            .build();

    private static final SdkField<String> IDENTITY_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentitySourceArn").getter(getter(CreateIdentitySourceResponse::identitySourceArn))
            .setter(setter(Builder::identitySourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(CreateIdentitySourceResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_SOURCE_TYPE_FIELD,
            IDENTITY_SOURCE_ARN_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identitySourceType;

    private final String identitySourceArn;

    private final Instant creationTime;

    private CreateIdentitySourceResponse(BuilderImpl builder) {
        super(builder);
        this.identitySourceType = builder.identitySourceType;
        this.identitySourceArn = builder.identitySourceArn;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The type of resource that provided identities to the identity source. For example, an IAM Identity Center
     * instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identitySourceType} will return {@link IdentitySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identitySourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that provided identities to the identity source. For example, an IAM Identity Center
     *         instance.
     * @see IdentitySourceType
     */
    public final IdentitySourceType identitySourceType() {
        return IdentitySourceType.fromValue(identitySourceType);
    }

    /**
     * <p>
     * The type of resource that provided identities to the identity source. For example, an IAM Identity Center
     * instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identitySourceType} will return {@link IdentitySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identitySourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that provided identities to the identity source. For example, an IAM Identity Center
     *         instance.
     * @see IdentitySourceType
     */
    public final String identitySourceTypeAsString() {
        return identitySourceType;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the identity source that was created.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the identity source that was created.
     */
    public final String identitySourceArn() {
        return identitySourceArn;
    }

    /**
     * <p>
     * Timestamp when the identity source was created.
     * </p>
     * 
     * @return Timestamp when the identity source was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentitySourceResponse)) {
            return false;
        }
        CreateIdentitySourceResponse other = (CreateIdentitySourceResponse) obj;
        return Objects.equals(identitySourceTypeAsString(), other.identitySourceTypeAsString())
                && Objects.equals(identitySourceArn(), other.identitySourceArn())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIdentitySourceResponse").add("IdentitySourceType", identitySourceTypeAsString())
                .add("IdentitySourceArn", identitySourceArn()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentitySourceType":
            return Optional.ofNullable(clazz.cast(identitySourceTypeAsString()));
        case "IdentitySourceArn":
            return Optional.ofNullable(clazz.cast(identitySourceArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentitySourceType", IDENTITY_SOURCE_TYPE_FIELD);
        map.put("IdentitySourceArn", IDENTITY_SOURCE_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIdentitySourceResponse, T> g) {
        return obj -> g.apply((CreateIdentitySourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateIdentitySourceResponse> {
        /**
         * <p>
         * The type of resource that provided identities to the identity source. For example, an IAM Identity Center
         * instance.
         * </p>
         * 
         * @param identitySourceType
         *        The type of resource that provided identities to the identity source. For example, an IAM Identity
         *        Center instance.
         * @see IdentitySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentitySourceType
         */
        Builder identitySourceType(String identitySourceType);

        /**
         * <p>
         * The type of resource that provided identities to the identity source. For example, an IAM Identity Center
         * instance.
         * </p>
         * 
         * @param identitySourceType
         *        The type of resource that provided identities to the identity source. For example, an IAM Identity
         *        Center instance.
         * @see IdentitySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentitySourceType
         */
        Builder identitySourceType(IdentitySourceType identitySourceType);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the identity source that was created.
         * </p>
         * 
         * @param identitySourceArn
         *        Amazon Resource Name (ARN) for the identity source that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySourceArn(String identitySourceArn);

        /**
         * <p>
         * Timestamp when the identity source was created.
         * </p>
         * 
         * @param creationTime
         *        Timestamp when the identity source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends MpaResponse.BuilderImpl implements Builder {
        private String identitySourceType;

        private String identitySourceArn;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentitySourceResponse model) {
            super(model);
            identitySourceType(model.identitySourceType);
            identitySourceArn(model.identitySourceArn);
            creationTime(model.creationTime);
        }

        public final String getIdentitySourceType() {
            return identitySourceType;
        }

        public final void setIdentitySourceType(String identitySourceType) {
            this.identitySourceType = identitySourceType;
        }

        @Override
        public final Builder identitySourceType(String identitySourceType) {
            this.identitySourceType = identitySourceType;
            return this;
        }

        @Override
        public final Builder identitySourceType(IdentitySourceType identitySourceType) {
            this.identitySourceType(identitySourceType == null ? null : identitySourceType.toString());
            return this;
        }

        public final String getIdentitySourceArn() {
            return identitySourceArn;
        }

        public final void setIdentitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
        }

        @Override
        public final Builder identitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateIdentitySourceResponse build() {
            return new CreateIdentitySourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
